/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools;

import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SailWriter
implements RDFHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Sail sail;
    private final Action action;
    private SailConnection sailConnection;

    public SailWriter(Sail sail, Action action) {
        this.sail = sail;
        this.action = action;
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (null != this.sailConnection) {
            this.sailConnection.close();
        }
        this.sailConnection = null;
    }

    public void startRDF() throws RDFHandlerException {
        try {
            this.sailConnection = this.sail.getConnection();
        }
        catch (SailException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void endRDF() throws RDFHandlerException {
        try {
            this.sailConnection.commit();
        }
        catch (SailException e) {
            throw new RDFHandlerException((Throwable)e);
        }
        finally {
            if (null != this.sailConnection) {
                try {
                    this.sailConnection.close();
                }
                catch (SailException e) {
                    this.log.error("Found SailException while trying to close Sail connection in SailWriter", (Throwable)e);
                }
            }
            this.sailConnection = null;
        }
    }

    public void handleNamespace(String s, String s1) throws RDFHandlerException {
        try {
            switch (this.action) {
                case ADD: {
                    this.sailConnection.setNamespace(s, s1);
                    break;
                }
                case REMOVE: {
                    String name = this.sailConnection.getNamespace(s);
                    if (null == name || !name.equals(s1)) break;
                    this.sailConnection.removeNamespace(s);
                }
            }
        }
        catch (SailException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleStatement(Statement statement) throws RDFHandlerException {
        try {
            switch (this.action) {
                case ADD: {
                    this.sailConnection.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[]{statement.getContext()});
                    break;
                }
                case REMOVE: {
                    this.sailConnection.removeStatements(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[]{statement.getContext()});
                }
            }
        }
        catch (SailException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleComment(String s) throws RDFHandlerException {
    }

    public static enum Action {
        ADD,
        REMOVE;

    }
}

