/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsonorg;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.datatype.jsonorg.JSONBaseSerializer;
import com.fasterxml.jackson.datatype.jsonorg.JSONObjectSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONArraySerializer
extends JSONBaseSerializer<JSONArray> {
    public static final JSONArraySerializer instance = new JSONArraySerializer();

    public JSONArraySerializer() {
        super(JSONArray.class);
    }

    public void serialize(JSONArray jSONArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        jsonGenerator.writeStartArray();
        this.serializeContents(jSONArray, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    public void serializeWithType(JSONArray jSONArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        typeSerializer.writeTypePrefixForArray((Object)jSONArray, jsonGenerator);
        this.serializeContents(jSONArray, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffixForArray((Object)jSONArray, jsonGenerator);
    }

    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        return this.createSchemaNode("array", true);
    }

    protected void serializeContents(JSONArray jSONArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            Object object = jSONArray.opt(i);
            if (object == null || object == JSONObject.NULL) {
                jsonGenerator.writeNull();
                continue;
            }
            Class<?> clazz = object.getClass();
            if (clazz == JSONObject.class) {
                JSONObjectSerializer.instance.serialize((JSONObject)object, jsonGenerator, serializerProvider);
                continue;
            }
            if (clazz == JSONArray.class) {
                this.serialize((JSONArray)object, jsonGenerator, serializerProvider);
                continue;
            }
            if (clazz == String.class) {
                jsonGenerator.writeString((String)object);
                continue;
            }
            if (clazz == Integer.class) {
                jsonGenerator.writeNumber(((Integer)object).intValue());
                continue;
            }
            if (clazz == Long.class) {
                jsonGenerator.writeNumber(((Long)object).longValue());
                continue;
            }
            if (clazz == Boolean.class) {
                jsonGenerator.writeBoolean(((Boolean)object).booleanValue());
                continue;
            }
            if (clazz == Double.class) {
                jsonGenerator.writeNumber(((Double)object).doubleValue());
                continue;
            }
            if (JSONObject.class.isAssignableFrom(clazz)) {
                JSONObjectSerializer.instance.serialize((JSONObject)object, jsonGenerator, serializerProvider);
                continue;
            }
            if (JSONArray.class.isAssignableFrom(clazz)) {
                this.serialize((JSONArray)object, jsonGenerator, serializerProvider);
                continue;
            }
            if (JSONArray.class.isAssignableFrom(clazz)) {
                instance.serialize((JSONArray)object, jsonGenerator, serializerProvider);
                continue;
            }
            serializerProvider.defaultSerializeValue(object, jsonGenerator);
        }
    }
}

