/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.security;

import java.security.Principal;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.SubjectFactory;

public class DefaultSubjectFactory
implements SubjectFactory {
    private String securityDomain;
    private String userName;
    private String password;

    public DefaultSubjectFactory() {
        this(null, null, null);
    }

    public DefaultSubjectFactory(String securityDomain, String userName, String password) {
        this.securityDomain = securityDomain;
        this.userName = userName;
        this.password = password;
    }

    public void setSecurityDomain(String v) {
        this.securityDomain = v;
    }

    public void setUserName(String v) {
        this.userName = v;
    }

    public void setPassword(String v) {
        this.password = v;
    }

    public Subject createSubject() {
        if (this.userName == null) {
            throw new IllegalStateException("UserName is null");
        }
        if (this.password == null) {
            throw new IllegalStateException("Password is null");
        }
        Subject subject = new Subject();
        SimplePrincipal p = new SimplePrincipal(this.userName);
        subject.getPrincipals().add((Principal)p);
        PasswordCredential credential = new PasswordCredential(this.userName, this.password.toCharArray());
        subject.getPrivateCredentials().add(credential);
        return subject;
    }

    public Subject createSubject(String securityDomain) {
        return this.createSubject();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.securityDomain == null ? 0 : this.securityDomain.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultSubjectFactory)) {
            return false;
        }
        DefaultSubjectFactory other = (DefaultSubjectFactory)obj;
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.securityDomain == null ? other.securityDomain != null : !this.securityDomain.equals(other.securityDomain)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }

    public String toString() {
        return "DefaultSubjectFactory [securityDomain=" + this.securityDomain + ", userName=" + this.userName + "]";
    }
}

