/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.frames.modules.javahandler;

import com.tinkerpop.blueprints.Element;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.modules.MethodHandler;
import com.tinkerpop.frames.modules.javahandler.JavaHandler;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerException;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerModule;
import com.tinkerpop.frames.util.ExceptionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class JavaMethodHandler
implements MethodHandler<JavaHandler> {
    private JavaHandlerModule module;

    JavaMethodHandler(JavaHandlerModule module) {
        this.module = module;
    }

    @Override
    public Class<JavaHandler> getAnnotationType() {
        return JavaHandler.class;
    }

    @Override
    public Object processElement(Object framedElement, Method method, Object[] arguments, JavaHandler annotation, FramedGraph<?> framedGraph, Element element) {
        try {
            Object handler = this.module.createHandler(framedElement, framedGraph, element, method.getDeclaringClass(), method);
            return method.invoke(handler, arguments);
        }
        catch (IllegalArgumentException e) {
            throw new JavaHandlerException("Problem calling Java handler", e);
        }
        catch (IllegalAccessException e) {
            throw new JavaHandlerException("Problem calling Java handler", e);
        }
        catch (InvocationTargetException e) {
            ExceptionUtils.sneakyThrow(e.getTargetException());
            return null;
        }
    }
}

