/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.ip;

import java.util.HashMap;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.model.WindupVertexListModel;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.rules.apps.java.ip.StaticIPLocationModel;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CreateStaticIPAddressReportRuleProvider
extends AbstractRuleProvider {
    private static final String TITLE = "Static IP Addresses";
    public static final String TEMPLATE_REPORT = "/reports/templates/static_ip_addresses.ftl";

    public CreateStaticIPAddressReportRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(CreateStaticIPAddressReportRuleProvider.class).setPhase(ReportGenerationPhase.class));
    }

    public Configuration getConfiguration(GraphContext graphContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(StaticIPLocationModel.class)).perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                ProjectModel projectModel = configurationModel.getInputPath().getProjectModel();
                CreateStaticIPAddressReportRuleProvider.this.createIPReport(event.getGraphContext(), projectModel);
            }
        });
    }

    private ApplicationReportModel createIPReport(GraphContext context, ProjectModel rootProjectModel) {
        ApplicationReportService applicationReportService = new ApplicationReportService(context);
        ApplicationReportModel applicationReport = applicationReportService.create();
        applicationReport.setReportPriority(600);
        applicationReport.setReportName(TITLE);
        applicationReport.setTemplatePath(TEMPLATE_REPORT);
        applicationReport.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
        applicationReport.setReportIconClass("glyphicon glyphicon-map-marker");
        applicationReport.setTemplateType(TemplateType.FREEMARKER);
        applicationReport.setProjectModel(rootProjectModel);
        GraphService ipLocationModelService = new GraphService(context, StaticIPLocationModel.class);
        Iterable results = ipLocationModelService.findAll();
        HashMap<String, WindupVertexListModel> relatedData = new HashMap<String, WindupVertexListModel>(1);
        WindupVertexListModel staticIPList = (WindupVertexListModel)new GraphService(context, WindupVertexListModel.class).create();
        for (StaticIPLocationModel location : results) {
            staticIPList.addItem((WindupVertexFrame)location);
        }
        relatedData.put("staticIPLocations", staticIPList);
        applicationReport.setRelatedResource(relatedData);
        ReportService reportService = new ReportService(context);
        reportService.setUniqueFilename((ReportModel)applicationReport, "static_ips" + rootProjectModel.getName(), "html");
        return applicationReport;
    }
}

