/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.collections.ImmutableList;
import com.strobel.collections.ListBuffer;
import com.strobel.core.Comparer;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.ArrayType;
import com.strobel.reflection.CapturedType;
import com.strobel.reflection.ErasedType;
import com.strobel.reflection.ICapturedType;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MethodBase;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.SimpleVisitor;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBinder;
import com.strobel.reflection.TypeBindings;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.TypeMapper;
import com.strobel.reflection.TypeMapping;
import com.strobel.reflection.TypeRelation;
import com.strobel.reflection.TypeVisitor;
import com.strobel.reflection.Types;
import com.strobel.reflection.UnaryTypeVisitor;
import com.strobel.reflection.WildcardType;
import com.strobel.reflection.emit.TypeBuilder;
import com.strobel.util.TypeUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeKind;

final class Helper {
    private static final TypeMapping ErasureFunctor = new TypeMapping("erasure"){

        public Type apply(Type t) {
            return Helper.erasure(t);
        }
    };
    private static final TypeMapping ErasureRecursiveFunctor = new TypeMapping("erasureRecursive"){

        public Type apply(Type t) {
            return Helper.erasureRecursive(t);
        }
    };
    private static final TypeBinder SubstitutingBinder = new TypeBinder();
    private static final TypeVisitor<Type, Type> AsSuperVisitor = new SimpleVisitor<Type, Type>(){

        @Override
        public Type visitClassType(Type t, Type p) {
            Type ancestor;
            Type superType;
            if (t == p) {
                return t;
            }
            if (t == null) {
                return null;
            }
            if (t.isGenericType()) {
                if (p.isGenericType()) {
                    if (t.getGenericTypeDefinition() == p.getGenericTypeDefinition()) {
                        boolean areTypeArgumentsAssignable = true;
                        TypeList ta = t.getTypeArguments();
                        TypeList tp = p.getTypeArguments();
                        int n = ta.size();
                        for (int i = 0; i < n; ++i) {
                            Type<?> extendsBound;
                            Type at = (Type)ta.get(i);
                            Type ap = (Type)tp.get(i);
                            if (ap == at || ap.hasExtendsBound() && ((extendsBound = ap.getExtendsBound()) == p || extendsBound.isAssignableFrom(at)) || ap.hasSuperBound() && Helper.isSuperType(at, ap.getSuperBound())) continue;
                            areTypeArgumentsAssignable = false;
                            break;
                        }
                        if (areTypeArgumentsAssignable) {
                            return t;
                        }
                    }
                } else if (p instanceof ErasedType && t.getErasedType() == p) {
                    return t;
                }
            }
            if ((superType = Helper.superType(t)) != null && !superType.isInterface() && (ancestor = Helper.asSuper(superType, p)) != null) {
                return ancestor;
            }
            TypeList interfaces = t.getExplicitInterfaces();
            int n = interfaces.size();
            for (int i = 0; i < n; ++i) {
                Type ancestor2 = Helper.asSuper((Type)interfaces.get(i), p);
                if (ancestor2 == null) continue;
                return ancestor2;
            }
            return null;
        }

        @Override
        public Type visitPrimitiveType(Type t, Type p) {
            if (t == p) {
                return t;
            }
            return null;
        }

        @Override
        public Type visitTypeParameter(Type t, Type p) {
            if (t == p) {
                return t;
            }
            return Helper.asSuper(t.getExtendsBound(), p);
        }

        @Override
        public Type visitArrayType(Type t, Type p) {
            return Helper.isSubtype(t, p) ? p : null;
        }

        @Override
        public Type visitType(Type t, Type p) {
            return (Type)super.visitType(t, p);
        }
    };
    private static final TypeRelation IsSameTypeRelation = new TypeRelation(){

        @Override
        public Boolean visitCapturedType(Type t, Type p) {
            return (Boolean)super.visitCapturedType(t, p);
        }

        @Override
        public Boolean visitClassType(Type type, Type parameter) {
            return (Boolean)super.visitClassType(type, parameter);
        }

        @Override
        public Boolean visitPrimitiveType(Type type, Type parameter) {
            return type == parameter ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public Boolean visitTypeParameter(Type type, Type parameter) {
            return StringUtilities.equals((String)type.getFullName(), (String)parameter.getFullName()) && Comparer.equals((Object)type.getDeclaringType(), (Object)parameter.getDeclaringType()) && Comparer.equals((Object)type.getDeclaringMethod(), (Object)parameter.getDeclaringMethod()) && (Boolean)this.visit(type.getExtendsBound(), parameter.getExtendsBound()) != false;
        }

        @Override
        public Boolean visitWildcardType(Type type, Type parameter) {
            return parameter.hasSuperBound() && !parameter.hasExtendsBound() && (Boolean)this.visit(type, Helper.upperBound(parameter)) != false;
        }

        @Override
        public Boolean visitArrayType(Type type, Type parameter) {
            return (Boolean)super.visitArrayType(type, parameter);
        }

        @Override
        public Boolean visitType(Type type, Type parameter) {
            return type == parameter;
        }
    };
    private static final TypeMapper<Void> UpperBoundVisitor = new TypeMapper<Void>(){

        @Override
        public Type visitWildcardType(Type t, Void ignored) {
            if (t.hasSuperBound()) {
                Type<?> lowerBound = t.getSuperBound();
                if (lowerBound.hasExtendsBound()) {
                    return (Type)this.visit(lowerBound.getExtendsBound());
                }
                return Types.Object;
            }
            return (Type)this.visit(t.getExtendsBound());
        }

        @Override
        public Type visitCapturedType(Type t, Void ignored) {
            return (Type)this.visit(t.getExtendsBound());
        }
    };
    private static final TypeMapper<Void> LowerBoundVisitor = new TypeMapper<Void>(){

        @Override
        public Type visitWildcardType(Type t, Void ignored) {
            return t.hasExtendsBound() ? Type.Bottom : (Type)this.visit(t.getSuperBound());
        }

        @Override
        public Type visitCapturedType(Type t, Void ignored) {
            return (Type)this.visit(t.getSuperBound());
        }
    };
    private static final TypeMapper<Boolean> ErasureVisitor = new TypeMapper<Boolean>(){

        @Override
        public Type visitType(Type t, Boolean recurse) {
            if (t.isPrimitive()) {
                return t;
            }
            return (Type)(recurse != false ? ErasureRecursiveFunctor : ErasureFunctor).apply(t);
        }

        @Override
        public Type visitWildcardType(Type t, Boolean recurse) {
            return Helper.erasure(Helper.upperBound(t), recurse);
        }

        @Override
        public Type<?> visitClassType(Type<?> t, Boolean recurse) {
            return Type.of(t.getErasedClass());
        }

        @Override
        public Type visitTypeParameter(Type t, Boolean recurse) {
            return Helper.erasure(t.getExtendsBound(), recurse);
        }

        @Override
        public Type<?> visitArrayType(Type<?> type, Boolean recurse) {
            return Helper.erasure(type.getElementType(), recurse).makeArrayType();
        }
    };
    private static final TypeRelation ContainsTypeRelation = new TypeRelation(){

        private Type U(Type t) {
            while (t.isWildcardType()) {
                if (t.hasSuperBound()) {
                    Type<?> lowerBound = t.getSuperBound();
                    if (lowerBound.hasExtendsBound()) {
                        return lowerBound.getExtendsBound();
                    }
                    return Types.Object;
                }
                t = t.getExtendsBound();
            }
            return t;
        }

        private Type L(Type t) {
            while (t.isWildcardType()) {
                if (t.hasExtendsBound()) {
                    return Type.Bottom;
                }
                t = t.getSuperBound();
            }
            return t;
        }

        @Override
        public Boolean visitType(Type t, Type p) {
            return Helper.isSameType(t, p);
        }

        @Override
        public Boolean visitWildcardType(Type t, Type p) {
            return Helper.isSameWildcard(t, p) || Helper.isCaptureOf(p, t) || (t.hasExtendsBound() || Helper.isSubtypeNoCapture(this.L(t), Helper.lowerBound(p))) && (t.hasSuperBound() || Helper.isSubtypeNoCapture(Helper.upperBound(p), this.U(t)));
        }
    };
    private static final SimpleVisitor<ImmutableList<Type<?>>, ImmutableList<Type<?>>> InterfacesVisitor = new SimpleVisitor<ImmutableList<Type<?>>, ImmutableList<Type<?>>>(){

        @Override
        public ImmutableList<Type<?>> visitPrimitiveType(Type<?> type, ImmutableList<Type<?>> parameter) {
            return ImmutableList.empty();
        }

        @Override
        public ImmutableList<Type<?>> visitArrayType(Type<?> type, ImmutableList<Type<?>> parameter) {
            return ImmutableList.empty();
        }

        @Override
        public ImmutableList<Type<?>> visitCapturedType(Type<?> t, ImmutableList<Type<?>> s) {
            return ImmutableList.empty();
        }

        @Override
        public ImmutableList<Type<?>> visit(Type<?> type) {
            return ImmutableList.empty();
        }

        @Override
        public ImmutableList<Type<?>> visitType(Type<?> t, ImmutableList<Type<?>> ignored) {
            return ImmutableList.empty();
        }

        @Override
        public ImmutableList<Type<?>> visitClassType(Type<?> t, ImmutableList<Type<?>> list) {
            TypeList interfaces = t.getExplicitInterfaces();
            if (interfaces.isEmpty()) {
                return ImmutableList.empty();
            }
            ImmutableList<Type<?>> result = Helper.union(list, ImmutableList.from((Object[])t.getExplicitInterfaces().toArray()));
            Iterator iterator = interfaces.iterator();
            while (iterator.hasNext()) {
                Type ifType = (Type)iterator.next();
                if (list.contains((Object)ifType)) continue;
                result = Helper.union(result, (ImmutableList)this.visit(ifType, result));
            }
            return result;
        }

        @Override
        public ImmutableList<Type<?>> visitTypeParameter(Type<?> t, ImmutableList<Type<?>> list) {
            Type<?> upperBound = t.getExtendsBound();
            if (upperBound.isCompoundType()) {
                return Helper.interfaces(upperBound);
            }
            if (upperBound.isInterface()) {
                return ImmutableList.of(upperBound);
            }
            return ImmutableList.empty();
        }

        @Override
        public ImmutableList<Type<?>> visitWildcardType(Type<?> type, ImmutableList<Type<?>> list) {
            return this.visit(type.getExtendsBound());
        }
    };
    private static final UnaryTypeVisitor<Type> SuperTypeVisitor = new UnaryTypeVisitor<Type>(){

        @Override
        public Type visitType(Type t, Void ignored) {
            return null;
        }

        @Override
        public Type visitClassType(Type t, Void ignored) {
            return t.getBaseType();
        }

        @Override
        public Type visitTypeParameter(Type t, Void ignored) {
            Type<?> bound = t.getExtendsBound();
            if (!bound.isCompoundType() && !bound.isInterface()) {
                return bound;
            }
            return Helper.superType(bound);
        }

        @Override
        public Type visitArrayType(Type t, Void ignored) {
            Type elementType = t.getElementType();
            if (elementType.isPrimitive() || Helper.isSameType(elementType, Types.Object)) {
                return Helper.arraySuperType();
            }
            return new ArrayType(Helper.superType(elementType));
        }
    };
    private static final TypeRelation IsSubtypeRelation = new TypeRelation(){
        private final Set<TypePair> cache = new HashSet<TypePair>();

        @Override
        public Boolean visitPrimitiveType(Type t, Type p) {
            if (t == p) {
                return true;
            }
            if (t == PrimitiveTypes.Byte) {
                return p == PrimitiveTypes.Character || p == PrimitiveTypes.Short;
            }
            if (t == PrimitiveTypes.Character) {
                return p == PrimitiveTypes.Short || p == PrimitiveTypes.Integer;
            }
            if (t == PrimitiveTypes.Short) {
                return p == PrimitiveTypes.Integer || p == PrimitiveTypes.Long || p == PrimitiveTypes.Float || p == PrimitiveTypes.Double;
            }
            if (t == PrimitiveTypes.Integer) {
                return p == PrimitiveTypes.Long || p == PrimitiveTypes.Float || p == PrimitiveTypes.Double;
            }
            if (t == PrimitiveTypes.Long) {
                return p == PrimitiveTypes.Float || p == PrimitiveTypes.Double;
            }
            if (t == PrimitiveTypes.Float) {
                return p == PrimitiveTypes.Double;
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitType(Type t, Type s) {
            if (t.isGenericParameter()) {
                return Helper.isSubtypeNoCapture(t.getExtendsBound(), s);
            }
            return Boolean.FALSE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean containsTypeRecursive(Type t, Type s) {
            TypePair pair = new TypePair(t, s);
            if (this.cache.add(pair)) {
                try {
                    boolean bl = Helper.containsType(t.getTypeArguments(), s.getTypeArguments());
                    return bl;
                }
                finally {
                    this.cache.remove(pair);
                }
            }
            return Helper.containsType(t.getTypeArguments(), this.rewriteSupers(s).getTypeArguments());
        }

        private Type rewriteSupers(Type t) {
            if (!t.isGenericType()) {
                return t;
            }
            ListBuffer from = ListBuffer.lb();
            ListBuffer to = ListBuffer.lb();
            Helper.adaptSelf(t, from, to);
            if (from.isEmpty()) {
                return t;
            }
            ListBuffer rewrite = ListBuffer.lb();
            boolean changed = false;
            for (Type orig : to.toList()) {
                WildcardType<Object> s = this.rewriteSupers(orig);
                if (s.hasSuperBound() && !s.hasExtendsBound()) {
                    s = new WildcardType<Object>(Types.Object, Type.Bottom);
                    changed = true;
                } else if (s != orig) {
                    s = new WildcardType(Helper.upperBound(s), Type.Bottom);
                    changed = true;
                }
                rewrite.append((Object)s);
            }
            if (changed) {
                return Helper.substitute(t.getGenericTypeDefinition(), from.toList(), rewrite.toList());
            }
            return t;
        }

        @Override
        public Boolean visitClassType(Type t, Type s) {
            Type asSuper = Helper.asSuper(t, s);
            return asSuper != null && (!s.isGenericParameter() && !s.isWildcardType() || this.containsTypeRecursive(s, asSuper)) && Helper.isSubtypeNoCapture(asSuper.getDeclaringType(), s.getDeclaringType());
        }

        @Override
        public Boolean visitArrayType(Type t, Type s) {
            Type elementType = t.getElementType();
            if (elementType.isPrimitive()) {
                return Helper.isSameType(elementType, Helper.elementType(s));
            }
            return Helper.isSubtypeNoCapture(elementType, Helper.elementType(s));
        }
    };
    private static final UnaryTypeVisitor<Integer> HashCodeVisitor = new UnaryTypeVisitor<Integer>(){

        @Override
        public Integer visitType(Type t, Void ignored) {
            return t.getKind().hashCode();
        }

        @Override
        public Integer visitClassType(Type t, Void ignored) {
            int result = 0;
            Type declaringType = t.getDeclaringType();
            if (declaringType != null) {
                result = (Integer)this.visit(declaringType);
            }
            result *= 127;
            result += t.getFullName().hashCode();
            Iterator iterator = t.getTypeArguments().iterator();
            while (iterator.hasNext()) {
                Type s = (Type)iterator.next();
                result *= 127;
                result += ((Integer)this.visit(s)).intValue();
            }
            return result;
        }

        @Override
        public Integer visitWildcardType(Type t, Void ignored) {
            int result = t.getKind().hashCode();
            if (t.getExtendsBound() != null) {
                result *= 127;
                result += ((Integer)this.visit(t.getExtendsBound())).intValue();
            }
            return result;
        }

        @Override
        public Integer visitArrayType(Type t, Void ignored) {
            return (Integer)this.visit(t.getElementType()) + 12;
        }

        @Override
        public Integer visitTypeParameter(Type t, Void ignored) {
            return System.identityHashCode(t);
        }
    };
    private static final UnaryTypeVisitor<Boolean> IsReifiableVisitor = new UnaryTypeVisitor<Boolean>(){

        @Override
        public Boolean visitType(Type t, Void ignored) {
            return true;
        }

        @Override
        public Boolean visitClassType(Type t, Void ignored) {
            if (t.isCompoundType()) {
                return Boolean.FALSE;
            }
            if (!t.isGenericType()) {
                return Boolean.TRUE;
            }
            Iterator iterator = t.getTypeArguments().iterator();
            while (iterator.hasNext()) {
                Type p = (Type)iterator.next();
                if (!p.isUnbounded()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        @Override
        public Boolean visitArrayType(Type t, Void ignored) {
            return (Boolean)this.visit(t.getElementType());
        }

        @Override
        public Boolean visitTypeParameter(Type t, Void ignored) {
            return false;
        }
    };
    private static Type _arraySuperType = null;
    private static final TypeBinder typeBinder = new TypeBinder();
    private static SimpleVisitor<MemberInfo, MemberInfo> asMemberOfVisitor = new SimpleVisitor<MemberInfo, MemberInfo>(){

        @Override
        public MemberInfo visitClassType(Type<?> type, MemberInfo member) {
            Type owner = member.getDeclaringType();
            if (!member.isStatic() && owner.isGenericType()) {
                Type base = Helper.asOuterSuper(type, owner);
                Type type2 = base = base.isCompoundType() ? Helper.capture(base) : base;
                if (base != null) {
                    TypeBindings ownerBindings = owner.getTypeBindings();
                    TypeBindings baseBindings = owner.getTypeBindings();
                    if (!ownerBindings.isEmpty()) {
                        if (baseBindings.isEmpty()) {
                            return typeBinder.visitMember(owner, member, TypeBindings.create(ownerBindings.getGenericParameters(), Helper.erasure(ownerBindings.getBoundTypes())));
                        }
                        return typeBinder.visitMember(owner, member, ownerBindings.withAdditionalBindings(base.getTypeBindings()));
                    }
                }
            }
            return member;
        }

        @Override
        public MemberInfo visitTypeParameter(Type<?> type, MemberInfo member) {
            return Helper.asMemberOf(type.getExtendsBound(), member);
        }

        @Override
        public MemberInfo visitWildcardType(Type<?> type, MemberInfo member) {
            return Helper.asMemberOf(Helper.upperBound(type), member);
        }

        @Override
        public MemberInfo visitType(Type<?> type, MemberInfo member) {
            return member;
        }
    };
    private static final Map<Type, ImmutableList<Type<?>>> closureCache = new HashMap();

    private Helper() {
    }

    public static boolean overrides(MethodInfo baseMethod, MethodInfo ancestorMethod) {
        Type baseReturnType;
        Type ancestorDeclaringType;
        int ancestorModifier;
        if (ancestorMethod.isFinal() || ancestorMethod.isPrivate()) {
            return false;
        }
        int baseModifier = baseMethod.getModifiers() & 7;
        if (baseModifier != (ancestorModifier = ancestorMethod.getModifiers() & 7)) {
            return false;
        }
        Method rawMethod = baseMethod.getRawMethod();
        if (rawMethod != null && rawMethod == ancestorMethod.getRawMethod()) {
            return true;
        }
        ParameterList baseParameters = baseMethod.getParameters();
        ParameterList ancestorParameters = ancestorMethod.getParameters();
        if (baseParameters.size() != ancestorParameters.size()) {
            return false;
        }
        if (!StringUtilities.equals((String)baseMethod.getName(), (String)ancestorMethod.getName())) {
            return false;
        }
        Type baseDeclaringType = Helper.erasure(baseMethod.getDeclaringType());
        if (!Helper.isSubtype(baseDeclaringType, ancestorDeclaringType = Helper.erasure(ancestorMethod.getDeclaringType()))) {
            return false;
        }
        Type ancestorReturnType = Helper.erasure(ancestorMethod.getReturnType());
        if (!ancestorReturnType.isAssignableFrom(baseReturnType = Helper.erasure(baseMethod.getReturnType()))) {
            return false;
        }
        TypeList erasedBaseParameters = Helper.erasure(baseParameters.getParameterTypes());
        TypeList erasedAncestorParameters = Helper.erasure(ancestorParameters.getParameterTypes());
        int n = ancestorParameters.size();
        for (int i = 0; i < n; ++i) {
            Type ancestorParameterType;
            Type baseParameterType = (Type)erasedBaseParameters.get(i);
            if (TypeUtils.areEquivalent(baseParameterType, ancestorParameterType = (Type)erasedAncestorParameters.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isOverridableIn(MethodInfo method, Type origin) {
        VerifyArgument.notNull((Object)method, (String)"method");
        VerifyArgument.notNull((Object)origin, (String)"origin");
        switch (method.getModifiers() & 7) {
            case 0: {
                return method.getDeclaringType().getPackage() == origin.getPackage() && !origin.isInterface();
            }
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
            case 4: {
                return !origin.isInterface();
            }
        }
        return false;
    }

    public static boolean overrides(MethodBase method, MethodBase other, boolean checkResult) {
        return method instanceof MethodInfo && other instanceof MethodInfo && Helper.overrides((MethodInfo)method, (MethodInfo)other, checkResult);
    }

    public static boolean overrides(MethodInfo method, MethodInfo other, boolean checkResult) {
        if (method == other) {
            return true;
        }
        if (!Helper.isOverridableIn(other, method.getDeclaringType())) {
            return false;
        }
        if (Helper.asSuper(method.getDeclaringType(), other.getDeclaringType()) != null && Helper.isSubSignature(method, other)) {
            if (!checkResult) {
                return true;
            }
            if (Helper.returnTypeSubstitutable(method, other)) {
                return true;
            }
        }
        if (method.isAbstract() || !other.isAbstract()) {
            return false;
        }
        return Helper.isSubSignature(method, other) && (!checkResult || Helper.resultSubtype(method, other));
    }

    public static boolean resultSubtype(MethodInfo t, MethodInfo s) {
        TypeList tVars = t.getTypeArguments();
        TypeList sVars = s.getTypeArguments();
        Type<?> tReturn = t.getReturnType();
        Type sReturn = Helper.substitute(s.getReturnType(), sVars, tVars);
        return Helper.covariantReturnType(tReturn, sReturn);
    }

    public static boolean covariantReturnType(Type t, Type s) {
        return Helper.isSameType(t, s) || !t.isPrimitive() && !s.isPrimitive() && Helper.isAssignable(t, s);
    }

    public static boolean isAssignable(Type sourceType, Type targetType) {
        if (VerifyArgument.notNull((Object)sourceType, (String)"sourceType") == VerifyArgument.notNull((Object)targetType, (String)"targetType")) {
            return true;
        }
        if (targetType.isGenericParameter() || targetType.hasExtendsBound()) {
            return Helper.isAssignable(sourceType, targetType.getExtendsBound());
        }
        if (sourceType instanceof TypeBuilder) {
            return Helper.isAssignable(sourceType.getBaseType(), targetType);
        }
        if (targetType instanceof TypeBuilder) {
            TypeBuilder targetTypeBuilder = (TypeBuilder)targetType;
            return targetTypeBuilder.isCreated() && Helper.isAssignable(sourceType, targetTypeBuilder.createType());
        }
        return Helper.isConvertible(sourceType, targetType);
    }

    public static boolean isConvertible(Type sourceType, Type targetType) {
        boolean tPrimitive = sourceType.isPrimitive();
        boolean sPrimitive = targetType.isPrimitive();
        if (sourceType == Type.NullType) {
            return !targetType.isPrimitive();
        }
        if (targetType == Types.Object) {
            return true;
        }
        if (targetType.isGenericParameter()) {
            return Helper.isConvertible(sourceType, targetType.getExtendsBound());
        }
        if (tPrimitive == sPrimitive) {
            return Helper.isSubtypeUnchecked(sourceType, targetType);
        }
        return tPrimitive ? Helper.isSubtype(TypeUtils.getBoxedTypeOrSelf(sourceType), targetType) : Helper.isSubtype(TypeUtils.getUnderlyingPrimitiveOrSelf(sourceType), targetType);
    }

    public static boolean isSubtypeUnchecked(Type t, Type s) {
        Type t2;
        if (t.isArray() && s.isArray()) {
            if (t.getElementType().isPrimitive()) {
                return Helper.isSameType(Helper.elementType(t), Helper.elementType(s));
            }
            return Helper.isSubtypeUnchecked(Helper.elementType(t), Helper.elementType(s));
        }
        if (Helper.isSubtype(t, s)) {
            return true;
        }
        if (t.isGenericParameter()) {
            return Helper.isSubtypeUnchecked(t.getExtendsBound(), s);
        }
        if (s.isGenericParameter()) {
            return Helper.isSubtypeUnchecked(t, s.getExtendsBound());
        }
        return s.isGenericType() && !s.isGenericTypeDefinition() && (t2 = Helper.asSuper(t, s)) != null;
    }

    public static boolean returnTypeSubstitutable(MethodInfo r1, MethodInfo r2) {
        if (Helper.hasSameArgs(r1, r2)) {
            return Helper.resultSubtype(r1, r2);
        }
        return Helper.covariantReturnType(r1.getReturnType(), Helper.erasure(r2.getReturnType()));
    }

    public static boolean isSubSignature(MethodInfo t, MethodInfo p) {
        return Helper.hasSameArgs(t, p) || Helper.containsTypeEquivalent(t.getParameters().getParameterTypes(), Helper.erasure(p.getParameters().getParameterTypes()));
    }

    public static boolean hasSameArgs(MethodInfo t, MethodInfo p) {
        return Helper.containsTypeEquivalent(t.getParameters().getParameterTypes(), p.getParameters().getParameterTypes());
    }

    public static boolean hasSameArgs(TypeList t, TypeList p) {
        return Helper.containsTypeEquivalent(t, p);
    }

    public static Type asSuper(Type type, Type other) {
        return AsSuperVisitor.visit(type, other);
    }

    public static boolean isSuperType(Type type, Type other) {
        if (type == other || other == Type.Bottom) {
            return true;
        }
        if (type.isGenericParameter()) {
            return Helper.isSuperType(type.getExtendsBound(), other);
        }
        return Helper.isSubtype(other, type);
    }

    public static boolean isSubtype(Type t, Type p) {
        return Helper.isSubtype(t, p, true);
    }

    public static boolean isSubtypeNoCapture(Type t, Type p) {
        return Helper.isSubtype(t, p, false);
    }

    public static boolean isSubtype(Type t, Type p, boolean capture) {
        if (t == p) {
            return true;
        }
        if (p == null) {
            return false;
        }
        if (p == Types.Object) {
            return true;
        }
        if (p.isCompoundType()) {
            Type baseType = p.getBaseType();
            if (baseType != null && !Helper.isSubtype(t, baseType, capture)) {
                return false;
            }
            TypeList interfaces = p.getExplicitInterfaces();
            int n = interfaces.size();
            for (int i = 0; i < n; ++i) {
                Type type = (Type)interfaces.get(i);
                if (Helper.isSubtype(t, type, capture)) continue;
                return false;
            }
            return true;
        }
        Type lower = Helper.lowerBound(p);
        if (p != lower) {
            return Helper.isSubtype(capture ? Helper.capture(t) : t, lower, false);
        }
        return (Boolean)IsSubtypeRelation.visit(capture ? Helper.capture(t) : t, p);
    }

    private static TypeList freshTypeVariables(TypeList types) {
        ListBuffer result = ListBuffer.lb();
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            Type t = (Type)iterator.next();
            if (t.isWildcardType()) {
                Type<?> bound = t.getExtendsBound();
                result.append(new CapturedType(Type.Bottom, bound, Type.Bottom, t));
                continue;
            }
            result.append((Object)t);
        }
        return new TypeList((List<? extends Type<?>>)result.toList());
    }

    public static Type capture(Type t) {
        Type<?> memberType;
        Type capturedDeclaringType;
        if (t.isGenericParameter() || t.isWildcardType() || t.isPrimitive() || t.isArray() || t == Type.Bottom || t == Type.NullType) {
            return t;
        }
        Type declaringType = t.getDeclaringType();
        if (declaringType != Type.Bottom && declaringType != null && (capturedDeclaringType = Helper.capture(declaringType)) != declaringType && (memberType = capturedDeclaringType.getNestedType(t.getFullName())) != null) {
            t = Helper.substitute(memberType, memberType.getGenericTypeParameters(), t.getTypeArguments());
        }
        if (!t.isGenericType()) {
            return t;
        }
        Type G = t.getGenericTypeDefinition();
        TypeList A = G.getTypeArguments();
        TypeList T = t.getTypeArguments();
        TypeList S = Helper.freshTypeVariables(T);
        ImmutableList currentA = ImmutableList.from((Object[])A.toArray());
        ImmutableList currentT = ImmutableList.from((Object[])T.toArray());
        ImmutableList currentS = ImmutableList.from((Object[])S.toArray());
        boolean captured = false;
        while (!(currentA.isEmpty() || currentT.isEmpty() || currentS.isEmpty())) {
            if (currentS.head != currentT.head) {
                captured = true;
                WildcardType Ti = (WildcardType)currentT.head;
                Type<Object> Ui = ((Type)currentA.head).getExtendsBound();
                CapturedType Si = (CapturedType)currentS.head;
                if (Ui == null) {
                    Ui = Types.Object;
                }
                if (Ti.isUnbounded()) {
                    currentS.head = Si = new CapturedType(Si.getDeclaringType(), Helper.substitute(Ui, A, S), Type.Bottom, Si.getWildcard());
                } else if (Ti.hasExtendsBound()) {
                    Si = new CapturedType(Si.getDeclaringType(), Helper.glb(Ti.getExtendsBound(), Helper.substitute(Ui, A, S)), Type.Bottom, Si.getWildcard());
                    currentS.head = Si;
                } else {
                    Si = new CapturedType(Si.getDeclaringType(), Helper.substitute(Ui, A, S), Ti.getSuperBound(), Si.getWildcard());
                    currentS.head = Si;
                }
                if (Si.getExtendsBound() == Si.getSuperBound()) {
                    currentS.head = Si.getExtendsBound();
                }
            }
            currentA = currentA.tail;
            currentT = currentT.tail;
            currentS = currentS.tail;
        }
        if (!(currentA.isEmpty() && currentT.isEmpty() && currentS.isEmpty())) {
            return Helper.erasure(t);
        }
        if (captured) {
            return t.getGenericTypeDefinition().makeGenericType((Type[])S.toArray());
        }
        return t;
    }

    static boolean containsType(ImmutableList<Type<?>> ts, ImmutableList<Type<?>> ss) {
        while (ts.nonEmpty() && ss.nonEmpty() && Helper.containsType((Type)ts.head, (Type)ss.head)) {
            ts = ts.tail;
            ss = ss.tail;
        }
        return ts.isEmpty() && ss.isEmpty();
    }

    static boolean containsType(TypeList ts, TypeList ss) {
        if (ts.size() != ss.size()) {
            return false;
        }
        if (ts.isEmpty()) {
            return true;
        }
        int n = ts.size();
        for (int i = 0; i < n; ++i) {
            if (Helper.containsType((Type)ts.get(i), (Type)ss.get(i))) continue;
            return false;
        }
        return true;
    }

    static boolean containsType(Type t, Type p) {
        return (Boolean)ContainsTypeRelation.visit(t, p);
    }

    static boolean containsTypeEquivalent(ImmutableList<Type<?>> ts, ImmutableList<Type<?>> tp) {
        while (ts.nonEmpty() && tp.nonEmpty() && Helper.containsTypeEquivalent((Type)ts.head, (Type)tp.head)) {
            ts = ts.tail;
            tp = tp.tail;
        }
        return ts.isEmpty() && tp.isEmpty();
    }

    static boolean containsTypeEquivalent(TypeList ts, TypeList tp) {
        if (ts.size() != tp.size()) {
            return false;
        }
        if (ts.isEmpty()) {
            return true;
        }
        int n = ts.size();
        for (int i = 0; i < n; ++i) {
            if (Helper.containsTypeEquivalent((Type)ts.get(i), (Type)tp.get(i))) continue;
            return false;
        }
        return true;
    }

    public static TypeList map(TypeList ts, TypeMapping f) {
        if (ts.isEmpty()) {
            return TypeList.empty();
        }
        Type[] results = null;
        int n = ts.size();
        for (int i = 0; i < n; ++i) {
            Type t = (Type)ts.get(i);
            Type r = (Type)f.apply(t);
            if (r == t) continue;
            if (results == null) {
                results = (Type[])ts.toArray();
            }
            results[i] = r;
        }
        if (results != null) {
            return new TypeList(results);
        }
        return ts;
    }

    private static boolean containsTypeEquivalent(Type t, Type p) {
        return Helper.isSameType(t, p) || Helper.containsType(t, p) && Helper.containsType(p, t);
    }

    public static boolean areSameTypes(TypeList ts, TypeList tp) {
        if (ts.size() != tp.size()) {
            return false;
        }
        if (ts.isEmpty()) {
            return true;
        }
        int n = ts.size();
        for (int i = 0; i < n; ++i) {
            if (Helper.isSameType((Type)ts.get(i), (Type)tp.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameType(Type t, Type p) {
        return (Boolean)IsSameTypeRelation.visit(t, p);
    }

    public static boolean isCaptureOf(Type p, Type t) {
        return p.isGenericParameter() && p instanceof ICapturedType && Helper.isSameWildcard(t, ((ICapturedType)((Object)p)).getWildcard());
    }

    public static boolean isSameWildcard(Type t, Type p) {
        if (!p.isWildcardType() || !t.isWildcardType()) {
            return false;
        }
        if (p.isUnbounded()) {
            return t.isUnbounded();
        }
        if (p.hasSuperBound()) {
            return t.hasSuperBound() && Helper.isSameType(p.getSuperBound(), t.getSuperBound());
        }
        return p.hasExtendsBound() && t.hasExtendsBound() && Helper.isSameType(p.getExtendsBound(), t.getExtendsBound());
    }

    public static Type glb(Type t, Type p) {
        if (p == null) {
            return t;
        }
        if (t.isPrimitive() || p.isPrimitive()) {
            return null;
        }
        if (Helper.isSubtypeNoCapture(t, p)) {
            return t;
        }
        if (Helper.isSubtypeNoCapture(p, t)) {
            return p;
        }
        ImmutableList<Type<?>> closure = Helper.union(Helper.closure(t), Helper.closure(p));
        ImmutableList<Type<?>> bounds = Helper.closureMin(closure);
        if (bounds.isEmpty()) {
            return Types.Object;
        }
        if (bounds.tail.isEmpty()) {
            return (Type)bounds.head;
        }
        int classCount = 0;
        for (Type bound : bounds) {
            if (bound.isInterface()) continue;
            ++classCount;
        }
        if (classCount > 1) {
            throw new AssertionError();
        }
        Type baseClass = Types.Object;
        ImmutableList interfaces = ImmutableList.empty();
        for (Type bound : bounds) {
            if (bound.isInterface()) {
                interfaces = interfaces.append((Object)bound);
                continue;
            }
            baseClass = bound;
        }
        return Type.makeCompoundType(baseClass, Type.list(interfaces));
    }

    public static Type elementType(Type t) {
        if (t.isArray()) {
            return t.getElementType();
        }
        if (t.isWildcardType()) {
            return Helper.elementType(Helper.upperBound(t));
        }
        return null;
    }

    public static Type<?> upperBound(Type<?> t) {
        return (Type)UpperBoundVisitor.visit(t);
    }

    public static Type lowerBound(Type t) {
        return (Type)LowerBoundVisitor.visit(t);
    }

    public static TypeList erasure(TypeList ts) {
        return Helper.map(ts, ErasureFunctor);
    }

    public static Type erasureRecursive(Type t) {
        return Helper.erasure(t, true);
    }

    public static TypeList erasureRecursive(TypeList ts) {
        return Helper.map(ts, ErasureRecursiveFunctor);
    }

    public static Type erasure(Type t) {
        return Helper.erasure(t, false);
    }

    public static Type substitute(Type type, ImmutableList<Type<?>> genericParameters, ImmutableList<Type<?>> typeArguments) {
        return (Type)SubstitutingBinder.visit(type, TypeBindings.create(Type.list(genericParameters), Type.list(typeArguments)));
    }

    public static Type substitute(Type type, TypeList genericParameters, TypeList typeArguments) {
        return (Type)SubstitutingBinder.visit(type, TypeBindings.create(genericParameters, typeArguments));
    }

    public static Type substitute(Type type, TypeBindings bindings) {
        return (Type)SubstitutingBinder.visit(type, bindings);
    }

    private static Type erasure(Type t, boolean recurse) {
        if (t.isPrimitive()) {
            return t;
        }
        return (Type)ErasureVisitor.visit(t, recurse);
    }

    public static ImmutableList<Type<?>> interfaces(Type type) {
        return (ImmutableList)InterfacesVisitor.visit(type, ImmutableList.empty());
    }

    public static int rank(Type t) {
        if (t == null) {
            return 0;
        }
        if (t.isPrimitive() || t.isWildcardType() || t.isArray() || t == Type.Bottom || t == Type.NullType) {
            throw new AssertionError();
        }
        if (t == Types.Object) {
            return 0;
        }
        int r = Helper.rank(Helper.superType(t));
        ImmutableList l = Helper.interfaces(t);
        while (l.nonEmpty()) {
            int headRank = Helper.rank((Type)l.head);
            if (headRank > r) {
                r = headRank;
            }
            l = l.tail;
        }
        return r + 1;
    }

    public static boolean precedes(Type origin, Type other) {
        boolean otherIsClass;
        if (origin == other) {
            return false;
        }
        if (origin.isGenericParameter() && other.isGenericParameter()) {
            return Helper.isSubtype(origin, other);
        }
        boolean originIsClass = !origin.isWildcardType() && !origin.isPrimitive() && !origin.isArray() && origin != Type.Bottom && origin != Type.NullType;
        boolean bl = otherIsClass = !other.isWildcardType() && !other.isPrimitive() && !other.isArray() && other != Type.Bottom && other != Type.NullType;
        if (originIsClass && otherIsClass) {
            return Helper.rank(other) < Helper.rank(origin) || Helper.rank(other) == Helper.rank(origin) && other.getFullName().compareTo(origin.getFullName()) < 0;
        }
        return origin.isGenericParameter();
    }

    public static ImmutableList<Type<?>> union(ImmutableList<Type<?>> cl1, ImmutableList<Type<?>> cl2) {
        if (cl1.isEmpty()) {
            return cl2;
        }
        if (cl2.isEmpty()) {
            return cl1;
        }
        if (Helper.precedes((Type)cl1.head, (Type)cl2.head)) {
            return Helper.union(cl1.tail, cl2).prepend(cl1.head);
        }
        if (Helper.precedes((Type)cl2.head, (Type)cl1.head)) {
            return Helper.union(cl1, cl2.tail).prepend(cl2.head);
        }
        return Helper.union(cl1.tail, cl2.tail).prepend(cl1.head);
    }

    public static boolean isInheritedIn(Type<?> site, MemberInfo member) {
        if (site == null || site == Type.NullType) {
            return false;
        }
        if (member.isPublic()) {
            return true;
        }
        Type declaringType = member.getDeclaringType();
        if (member.isPrivate()) {
            return TypeUtils.areEquivalent(site, declaringType);
        }
        if (member.isProtected()) {
            return !site.isInterface();
        }
        Type t = site;
        while (t != null && t != declaringType) {
            while (t != null && t.isGenericParameter()) {
                t = t.getExtendsBound();
            }
            if (t == null) {
                return true;
            }
            if (!t.isCompoundType() && !Helper.inSamePackage(t, declaringType)) {
                return false;
            }
            t = Helper.superType(t);
        }
        return !site.isInterface();
    }

    public static boolean inSamePackage(Type t1, Type t2) {
        int packageEnd2;
        if (t1 == t2) {
            return true;
        }
        String name1 = t1.getFullName();
        String name2 = t2.getFullName();
        if (name1 == null || name2 == null) {
            return false;
        }
        int packageEnd1 = name1.lastIndexOf(46);
        return packageEnd1 == (packageEnd2 = name2.lastIndexOf(46)) && (packageEnd1 < 0 || StringUtilities.substringEquals((CharSequence)name1, (int)0, (CharSequence)name2, (int)0, (int)packageEnd2));
    }

    public static Type superType(Type t) {
        return SuperTypeVisitor.visit(t);
    }

    public static void adapt(Type source, Type target, ListBuffer<Type<?>> from, ListBuffer<Type<?>> to) throws AdaptFailure {
        new Adapter(from, to).adapt(source, target);
    }

    private static void adaptSelf(Type t, ListBuffer<Type<?>> from, ListBuffer<Type<?>> to) {
        try {
            Helper.adapt(t.getGenericTypeDefinition(), t, from, to);
        }
        catch (AdaptFailure ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static int hashCode(Type t) {
        return HashCodeVisitor.visit(t);
    }

    public static boolean isReifiable(Type t) {
        return IsReifiableVisitor.visit(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Type arraySuperType() {
        if (_arraySuperType != null) return _arraySuperType;
        Class<Helper> clazz = Helper.class;
        synchronized (Helper.class) {
            if (_arraySuperType != null) return _arraySuperType;
            _arraySuperType = Type.makeCompoundType(Types.Object, Type.list(Types.Serializable, Types.Cloneable));
            // ** MonitorExit[var0] (shouldn't be in output)
            return _arraySuperType;
        }
    }

    public static Type asOuterSuper(Type t, Type type) {
        switch (t.getKind()) {
            case DECLARED: {
                do {
                    Type s;
                    if ((s = Helper.asSuper(t, type)) == null) continue;
                    return s;
                } while ((t = t.getDeclaringType()).getKind() == TypeKind.DECLARED);
                return null;
            }
            case ARRAY: {
                return Helper.isSubtype(t, type) ? type : null;
            }
            case TYPEVAR: {
                return Helper.asSuper(t, type);
            }
            case ERROR: {
                return t;
            }
        }
        return null;
    }

    public static MemberInfo asMemberOf(Type type, MemberInfo member) {
        return member.isStatic() ? member.getDeclaringType() : (MemberInfo)asMemberOfVisitor.visit(type, member);
    }

    public static ImmutableList<Type<?>> insert(ImmutableList<Type<?>> cl, Type t) {
        if (cl.isEmpty() || Helper.precedes(t, (Type)cl.head)) {
            return cl.prepend((Object)t);
        }
        if (Helper.precedes((Type)cl.head, t)) {
            return Helper.insert(cl.tail, t).prepend(cl.head);
        }
        return cl;
    }

    private static ImmutableList<Type<?>> closureMin(ImmutableList<Type<?>> cl) {
        ListBuffer classes = ListBuffer.lb();
        ListBuffer interfaces = ListBuffer.lb();
        while (!cl.isEmpty()) {
            Type current = (Type)cl.head;
            if (current.isInterface()) {
                interfaces.append((Object)current);
            } else {
                classes.append((Object)current);
            }
            ListBuffer candidates = ListBuffer.lb();
            for (Type t : cl.tail) {
                if (Helper.isSubtypeNoCapture(current, t)) continue;
                candidates.append((Object)t);
            }
            cl = candidates.toList();
        }
        return classes.appendList(interfaces).toList();
    }

    public static ImmutableList<Type<?>> closure(Type<?> t) {
        ImmutableList<Type<?>> cl = closureCache.get(t);
        if (cl == null) {
            Type st = Helper.superType(t);
            cl = !t.isCompoundType() ? (st != null && st.getKind() == TypeKind.DECLARED ? Helper.insert(Helper.closure(st), t) : (st != null && st.getKind() == TypeKind.TYPEVAR ? Helper.closure(st).prepend(t) : ImmutableList.of(t))) : Helper.closure(Helper.superType(t));
            ImmutableList l = Helper.interfaces(t);
            while (l.nonEmpty()) {
                cl = Helper.union(cl, Helper.closure((Type)l.head));
                l = l.tail;
            }
            closureCache.put(t, cl);
        }
        return cl;
    }

    static final class TypePair {
        final Type t1;
        final Type t2;

        TypePair(Type t1, Type t2) {
            this.t1 = t1;
            this.t2 = t2;
        }

        public int hashCode() {
            return 127 * Helper.hashCode(this.t1) + Helper.hashCode(this.t2);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypePair)) {
                return false;
            }
            TypePair typePair = (TypePair)obj;
            return Helper.isSameType(this.t1, typePair.t1) && Helper.isSameType(this.t2, typePair.t2);
        }
    }

    public static class AdaptFailure
    extends RuntimeException {
        static final long serialVersionUID = -7490231548272701566L;
    }

    private static final class Adapter
    extends SimpleVisitor<Type, Void> {
        ListBuffer<Type<?>> from;
        ListBuffer<Type<?>> to;
        Map<Type, Type> mapping;
        private final Set<TypePair> cache = new HashSet<TypePair>();

        Adapter(ListBuffer<Type<?>> from, ListBuffer<Type<?>> to) {
            this.from = from;
            this.to = to;
            this.mapping = new HashMap<Type, Type>();
        }

        public void adapt(Type source, Type target) throws AdaptFailure {
            this.visit(source, target);
            ImmutableList fromList = this.from.toList();
            ImmutableList toList = this.to.toList();
            while (!fromList.isEmpty()) {
                Type t = this.mapping.get(fromList.head);
                if (toList.head != t) {
                    toList.head = t;
                }
                fromList = fromList.tail;
                toList = toList.tail;
            }
        }

        @Override
        public Void visitClassType(Type source, Type target) throws AdaptFailure {
            this.adaptRecursive(source.getTypeArguments(), target.getTypeArguments());
            return null;
        }

        @Override
        public Void visitArrayType(Type source, Type target) throws AdaptFailure {
            this.adaptRecursive(Helper.elementType(source), Helper.elementType(target));
            return null;
        }

        @Override
        public Void visitWildcardType(Type source, Type target) throws AdaptFailure {
            if (source.hasExtendsBound()) {
                this.adaptRecursive(Helper.upperBound(source), Helper.upperBound(target));
            } else if (source.hasSuperBound()) {
                this.adaptRecursive(Helper.lowerBound(source), Helper.lowerBound(target));
            }
            return null;
        }

        @Override
        public Void visitTypeParameter(Type source, Type target) throws AdaptFailure {
            Type val = this.mapping.get(source);
            if (val != null) {
                if (val.hasSuperBound() && target.hasSuperBound()) {
                    val = Helper.isSubtype(Helper.lowerBound(val), Helper.lowerBound(target)) ? target : val;
                } else if (val.hasExtendsBound() && target.hasExtendsBound()) {
                    val = Helper.isSubtype(Helper.upperBound(val), Helper.upperBound(target)) ? val : target;
                } else if (!Helper.isSameType(val, target)) {
                    throw new AdaptFailure();
                }
            } else {
                val = target;
                this.from.append((Object)source);
                this.to.append((Object)target);
            }
            this.mapping.put(source, val);
            return null;
        }

        @Override
        public Void visitType(Type source, Type target) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void adaptRecursive(Type source, Type target) {
            TypePair pair = new TypePair(source, target);
            if (this.cache.add(pair)) {
                try {
                    this.visit(source, target);
                }
                finally {
                    this.cache.remove(pair);
                }
            }
        }

        private void adaptRecursive(TypeList source, TypeList target) throws AdaptFailure {
            if (source.size() != target.size()) {
                return;
            }
            int n = source.size();
            for (int i = 0; i < n; ++i) {
                this.adapt((Type)source.get(i), (Type)target.get(i));
            }
        }
    }
}

