/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.reflection.ArrayType;
import com.strobel.reflection.GenericType;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import java.util.LinkedHashMap;

final class TypeCache {
    private final LinkedHashMap<Key, Type> _map = new LinkedHashMap();
    private final LinkedHashMap<Class<?>, Type<?>> _erasedMap = new LinkedHashMap();
    private final LinkedHashMap<Type<?>, Type<?>> _arrayMap = new LinkedHashMap();

    TypeCache() {
    }

    public Key key(Class<?> simpleType) {
        return new Key(simpleType);
    }

    public Key key(Class<?> simpleType, TypeList typeArguments) {
        return new Key(simpleType, typeArguments);
    }

    public Type find(Key key) {
        return this._map.get(key);
    }

    public <T> Type<T[]> getArrayType(Type<T> elementType) {
        Type<T[]> arrayType = this._arrayMap.get(elementType);
        if (arrayType != null) {
            return arrayType;
        }
        arrayType = new ArrayType<T[]>(elementType);
        this.add(arrayType);
        return arrayType;
    }

    public <T> Type<T> getGenericType(Type<T> typeDefinition, TypeList typeArguments) {
        Type existing;
        Key key = this.key(typeDefinition.getErasedClass(), typeArguments);
        GenericType genericType = this._map.get(key);
        if (genericType == null && (existing = (Type)this._map.put(key, genericType = new GenericType(typeDefinition.getGenericTypeDefinition(), typeArguments))) != null) {
            return existing;
        }
        return genericType;
    }

    public <T> Type<T> find(Class<T> clazz) {
        return this._erasedMap.get(clazz);
    }

    public int size() {
        return this._map.size();
    }

    public void put(Key key, Type type) {
        Type elementType;
        Class erasedType = key._erasedType;
        if (!this._erasedMap.containsKey(erasedType)) {
            if (type.isGenericType() && !type.isGenericTypeDefinition()) {
                this._erasedMap.put(erasedType, type.getGenericTypeDefinition());
            } else {
                this._erasedMap.put(erasedType, type);
            }
        }
        this._map.put(key, type);
        if (type.isArray() && !this._arrayMap.containsKey(elementType = type.getElementType())) {
            this._arrayMap.put(elementType, type);
        }
    }

    public void add(Type type) {
        TypeList typeArguments = type.isGenericType() ? type.getTypeBindings().getBoundTypes() : TypeList.empty();
        this.put(this.key(type.getErasedClass(), typeArguments), type);
    }

    static class Key {
        private final Class<?> _erasedType;
        private final TypeList _typeParameters;
        private final int _hashCode;

        public Key(Class<?> simpleType) {
            this(simpleType, null);
        }

        public Key(Class<?> erasedType, TypeList typeArguments) {
            this._erasedType = erasedType;
            this._typeParameters = typeArguments;
            int h = erasedType.getName().hashCode();
            if (typeArguments != null && !typeArguments.isEmpty()) {
                h = h * 31 + typeArguments.size();
            }
            this._hashCode = h;
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            Key other = (Key)o;
            if (other._erasedType != this._erasedType) {
                return false;
            }
            TypeList otherArguments = other._typeParameters;
            if (this._typeParameters == null || this._typeParameters.isEmpty()) {
                return otherArguments == null || otherArguments.isEmpty();
            }
            if (otherArguments == null || otherArguments.size() != this._typeParameters.size()) {
                return false;
            }
            int n = this._typeParameters.size();
            for (int i = 0; i < n; ++i) {
                Type parameter = (Type)this._typeParameters.get(i);
                Type otherParameter = (Type)otherArguments.get(i);
                if (!(parameter == null ? otherParameter != null : !parameter.equals(otherParameter))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "Key{_erasedType=" + this._erasedType + ", _typeParameters=" + (Object)((Object)this._typeParameters) + ", _hashCode=" + this._hashCode + '}';
        }
    }
}

