/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.HashMap;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.model.WindupVertexListModel;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.rules.apps.javaee.model.JPAConfigurationFileModel;
import org.jboss.windup.rules.apps.javaee.model.JPAEntityModel;
import org.jboss.windup.rules.apps.javaee.model.JPANamedQueryModel;
import org.jboss.windup.rules.apps.javaee.service.JPAConfigurationFileService;
import org.jboss.windup.rules.apps.javaee.service.JPAEntityService;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CreateJPAReportRuleProvider
extends AbstractRuleProvider {
    public static final String TEMPLATE_JPA_REPORT = "/reports/templates/jpa.ftl";

    public CreateJPAReportRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(CreateJPAReportRuleProvider.class, (String)"Create JPA Report").setPhase(ReportGenerationPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        ConditionBuilder applicationProjectModelsFound = Query.fromType(JPAConfigurationFileModel.class).or((Condition)Query.fromType(JPAEntityModel.class)).or((Condition)Query.fromType(JPANamedQueryModel.class));
        GraphOperation addReport = new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel windupConfiguration = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                ProjectModel projectModel = windupConfiguration.getInputPath().getProjectModel();
                if (projectModel == null) {
                    throw new WindupException("Error, no project found in: " + windupConfiguration.getInputPath().getFilePath());
                }
                CreateJPAReportRuleProvider.this.createJPAReport(event.getGraphContext(), projectModel);
            }

            public String toString() {
                return "CreateJPAReport";
            }
        };
        return ConfigurationBuilder.begin().addRule().when((Condition)applicationProjectModelsFound).perform((Operation)addReport);
    }

    private void createJPAReport(GraphContext context, ProjectModel projectModel) {
        ApplicationReportService applicationReportService = new ApplicationReportService(context);
        ApplicationReportModel applicationReportModel = applicationReportService.create();
        applicationReportModel.setReportPriority(400);
        applicationReportModel.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
        applicationReportModel.setReportName("JPA");
        applicationReportModel.setReportIconClass("glyphicon jpa-nav-logo");
        applicationReportModel.setProjectModel(projectModel);
        applicationReportModel.setTemplatePath(TEMPLATE_JPA_REPORT);
        applicationReportModel.setTemplateType(TemplateType.FREEMARKER);
        JPAConfigurationFileService jpaConfigurationFileService = new JPAConfigurationFileService(context);
        JPAEntityService jpaEntityService = new JPAEntityService(context);
        GraphService jpaNamedQueryService = new GraphService(context, JPANamedQueryModel.class);
        GraphService listService = new GraphService(context, WindupVertexListModel.class);
        WindupVertexListModel jpaConfigList = (WindupVertexListModel)listService.create();
        for (Object jpaConfig : jpaConfigurationFileService.findAll()) {
            jpaConfigList.addItem((WindupVertexFrame)jpaConfig);
        }
        WindupVertexListModel entityList = (WindupVertexListModel)listService.create();
        for (Object entityModel : jpaEntityService.findAll()) {
            entityList.addItem((WindupVertexFrame)entityModel);
        }
        WindupVertexListModel namedQueryList = (WindupVertexListModel)listService.create();
        for (JPANamedQueryModel model : jpaNamedQueryService.findAll()) {
            namedQueryList.addItem((WindupVertexFrame)model);
        }
        HashMap<String, WindupVertexListModel> additionalData = new HashMap<String, WindupVertexListModel>(2);
        additionalData.put("jpaConfiguration", jpaConfigList);
        additionalData.put("jpaEntities", entityList);
        additionalData.put("jpaNamedQueries", namedQueryList);
        applicationReportModel.setRelatedResource(additionalData);
        ReportService reportService = new ReportService(context);
        reportService.setUniqueFilename((ReportModel)applicationReportModel, "jpa_" + projectModel.getName(), "html");
    }
}

