/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.Iteration;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.condition.JavaClass;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationLiteralTypeValueModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeValueModel;
import org.jboss.windup.rules.apps.java.scan.provider.AnalyzeJavaFilesRuleProvider;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.javaee.model.JaxWSWebServiceModel;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class DiscoverJaxWsAnnotationsRuleProvider
extends AbstractRuleProvider {
    private static Logger LOG = Logging.get(DiscoverJaxWsAnnotationsRuleProvider.class);
    private static final String JAXWS_ANNOTATIONS = "jaxwsAnnotations";

    public DiscoverJaxWsAnnotationsRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(DiscoverJaxWsAnnotationsRuleProvider.class).setPhase(InitialAnalysisPhase.class).addExecuteAfter(AnalyzeJavaFilesRuleProvider.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        String ruleIDPrefix = ((Object)((Object)this)).getClass().getSimpleName();
        return ConfigurationBuilder.begin().addRule().when((Condition)JavaClass.references((String)"javax.jws.WebService").at(new TypeReferenceLocation[]{TypeReferenceLocation.ANNOTATION}).as(JAXWS_ANNOTATIONS)).perform((Operation)Iteration.over((String)JAXWS_ANNOTATIONS).perform((Operation)new AbstractIterationOperation<JavaTypeReferenceModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel payload) {
                DiscoverJaxWsAnnotationsRuleProvider.this.extractMetadata(event, payload);
            }
        }).endIteration()).withId(ruleIDPrefix + "_JAXWSAnnotationRule");
    }

    private String getAnnotationLiteralValue(JavaAnnotationTypeReferenceModel model, String name) {
        JavaAnnotationTypeValueModel valueModel = (JavaAnnotationTypeValueModel)model.getAnnotationValues().get(name);
        if (valueModel instanceof JavaAnnotationLiteralTypeValueModel) {
            JavaAnnotationLiteralTypeValueModel literalTypeValue = (JavaAnnotationLiteralTypeValueModel)valueModel;
            return literalTypeValue.getLiteralValue();
        }
        return null;
    }

    private void extractMetadata(GraphRewrite event, JavaTypeReferenceModel typeReference) {
        GraphService jaxWsService = new GraphService(event.getGraphContext(), JaxWSWebServiceModel.class);
        JavaClassService jcs = new JavaClassService(event.getGraphContext());
        JavaClassModel jcm = this.getJavaClass(typeReference);
        if (!jcm.getInterfaces().iterator().hasNext()) {
            return;
        }
        LOG.info("Processing: " + typeReference);
        ((SourceFileModel)typeReference.getFile()).setGenerateSourceReport(true);
        JavaAnnotationTypeReferenceModel jaxWsAnnotationTypeReference = (JavaAnnotationTypeReferenceModel)typeReference;
        String endpointInterface = this.getAnnotationLiteralValue(jaxWsAnnotationTypeReference, "endpointInterface");
        JaxWSWebServiceModel jaxWebService = (JaxWSWebServiceModel)jaxWsService.create();
        if (StringUtils.isNotBlank((CharSequence)endpointInterface)) {
            JavaClassModel epi = jcs.getOrCreatePhantom(endpointInterface);
            for (JavaSourceFileModel source : jcs.getJavaSource(epi.getQualifiedName())) {
                source.setGenerateSourceReport(true);
            }
            jaxWebService.setInterface(epi);
        }
        if (jcm != null) {
            jaxWebService.setImplementationClass(jcm);
        }
    }

    private JavaClassModel getJavaClass(JavaTypeReferenceModel javaTypeReference) {
        JavaClassModel result = null;
        FileModel originalFile = javaTypeReference.getFile();
        if (originalFile instanceof JavaSourceFileModel) {
            JavaSourceFileModel javaSource = (JavaSourceFileModel)originalFile;
            for (JavaClassModel javaClassModel : javaSource.getJavaClasses()) {
                if (javaClassModel.isPublic() == null || !javaClassModel.isPublic().booleanValue()) continue;
                result = javaClassModel;
                break;
            }
            if (result == null) {
                result = (JavaClassModel)javaSource.getJavaClasses().iterator().next();
            }
        } else if (originalFile instanceof JavaClassFileModel) {
            result = ((JavaClassFileModel)originalFile).getJavaClass();
        } else {
            LOG.warning("Unrecognized file type with annotation found at: \"" + originalFile.getFilePath() + "\"");
        }
        return result;
    }

    public String toString() {
        return "DiscoverEJBAnnotatedClasses";
    }
}

