/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.jboss;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.javaee.model.EjbMessageDrivenModel;
import org.jboss.windup.rules.apps.javaee.model.EjbSessionBeanModel;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.model.JmsDestinationModel;
import org.jboss.windup.rules.apps.javaee.rules.DiscoverEjbConfigurationXmlRuleProvider;
import org.jboss.windup.rules.apps.javaee.service.EnvironmentReferenceService;
import org.jboss.windup.rules.apps.javaee.service.JNDIResourceService;
import org.jboss.windup.rules.apps.javaee.service.JmsDestinationService;
import org.jboss.windup.rules.apps.javaee.service.VendorSpecificationExtensionService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResolveJBossLegacyEjbXmlRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(ResolveJBossLegacyEjbXmlRuleProvider.class.getSimpleName());

    public ResolveJBossLegacyEjbXmlRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(ResolveJBossLegacyEjbXmlRuleProvider.class).setPhase(InitialAnalysisPhase.class).addExecuteAfter(DiscoverEjbConfigurationXmlRuleProvider.class));
    }

    public String toStringPerform() {
        return "Discover JBoss EJB XML Files";
    }

    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("rootTagName", (Object)"jboss").withProperty("fileName", (Object)"jboss.xml");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        String ejbName;
        XmlFileService xmlFileService = new XmlFileService(event.getGraphContext());
        Document doc = xmlFileService.loadDocumentQuiet(context, payload);
        if (JOOX.$((Document)doc).find("enterprise-beans").isEmpty()) {
            LOG.warning("Expected enterprise-beans tag. Ignoring: " + payload.getFileName());
            return;
        }
        EnvironmentReferenceService envRefService = new EnvironmentReferenceService(event.getGraphContext());
        JNDIResourceService jndiResourceService = new JNDIResourceService(event.getGraphContext());
        JmsDestinationService jmsDestinationService = new JmsDestinationService(event.getGraphContext());
        GraphService ejbSessionBeanService = new GraphService(event.getGraphContext(), EjbSessionBeanModel.class);
        GraphService mdbService = new GraphService(event.getGraphContext(), EjbMessageDrivenModel.class);
        ClassificationService classificationService = new ClassificationService(event.getGraphContext());
        classificationService.attachClassification(context, (FileModel)payload, "JBoss Legacy EJB XML", "JBoss Enterprise Java Bean XML Descriptor prior to EAP 6.");
        VendorSpecificationExtensionService vendorSpecificationService = new VendorSpecificationExtensionService(event.getGraphContext());
        vendorSpecificationService.associateAsVendorExtension((FileModel)payload, "ejb-jar.xml");
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        technologyTagService.addTagToFileModel((FileModel)payload, "JBoss EJB XML", TechnologyTagLevel.IMPORTANT);
        HashMap<String, String> resourceManagerReferences = new HashMap<String, String>();
        for (Element resourceRef : JOOX.$((Document)doc).find("resource-managers").children("resource-manager").get()) {
            String resourceName = JOOX.$((Element)resourceRef).child("res-name").text();
            String resourceJNDI = JOOX.$((Element)resourceRef).child("res-jndi-name").text();
            resourceManagerReferences.put(resourceName, resourceJNDI);
            LOG.info("Found Resource Manager: " + resourceName + ", " + resourceJNDI);
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("resource-ref").get()) {
            this.processBinding(envRefService, jndiResourceService, resourceManagerReferences, resourceRef, "res-ref-name", "jndi-name");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("resource-env-ref").get()) {
            this.processBinding(envRefService, jndiResourceService, resourceManagerReferences, resourceRef, "resource-env-ref-name", "jndi-name");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("message-destination-ref").get()) {
            this.processBinding(envRefService, jndiResourceService, resourceManagerReferences, resourceRef, "message-destination-ref-name", "jndi-name");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("ejb-ref").get()) {
            this.processBinding(envRefService, jndiResourceService, resourceManagerReferences, resourceRef, "ejb-ref-name", "jndi-name");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("ejb-local-ref").get()) {
            this.processBinding(envRefService, jndiResourceService, resourceManagerReferences, resourceRef, "ejb-ref-name", "local-jndi-name");
        }
        for (Element ejbRef : JOOX.$((Document)doc).find("session").get()) {
            ejbName = JOOX.$((Element)ejbRef).child("ejb-name").content();
            if (!StringUtils.isNotBlank((String)ejbName)) continue;
            LOG.info("Looking up name: " + ejbName);
            for (EjbSessionBeanModel ejb : ejbSessionBeanService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                JNDIResourceModel jndiRef;
                String jndi = JOOX.$((Element)ejbRef).child("jndi-name").content();
                String localJNDI = JOOX.$((Element)ejbRef).child("local-jndi-name").content();
                if (StringUtils.isNotBlank((String)jndi)) {
                    jndiRef = jndiResourceService.createUnique(jndi);
                    ejb.setGlobalJndiReference(jndiRef);
                }
                if (!StringUtils.isNotBlank((String)localJNDI)) continue;
                jndiRef = jndiResourceService.createUnique(localJNDI);
                ejb.setLocalJndiReference(jndiRef);
            }
        }
        for (Element messageDrivenRef : JOOX.$((Document)doc).find("message-driven").get()) {
            ejbName = JOOX.$((Element)messageDrivenRef).child("ejb-name").text();
            LOG.info("Found MDB: " + ejbName);
            if (!StringUtils.isNotBlank((String)ejbName)) continue;
            for (EjbMessageDrivenModel mdb : mdbService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                String destination = JOOX.$((Element)messageDrivenRef).child("destination-jndi-name").text();
                if (!StringUtils.isNotBlank((String)destination)) continue;
                JmsDestinationModel jndiRef = jmsDestinationService.createUnique(destination);
                mdb.setDestination(jndiRef);
            }
        }
    }

    private void processBinding(EnvironmentReferenceService envRefService, JNDIResourceService jndiResourceService, Map<String, String> resourceManagerReferences, Element resourceRef, String tagName, String tagJndi) {
        String jndiLocation = JOOX.$((Element)resourceRef).child(tagJndi).text();
        String resourceRefName = JOOX.$((Element)resourceRef).child(tagName).text();
        String resourceName = JOOX.$((Element)resourceRef).child("resource-name").text();
        LOG.info("Processing binding: " + JOOX.$((Element)resourceRef).toString());
        LOG.info("JNDI Name: " + jndiLocation + " to Resource: " + resourceRefName);
        if (StringUtils.isBlank((String)jndiLocation) && StringUtils.isNotBlank((String)resourceName)) {
            jndiLocation = resourceManagerReferences.get(resourceName);
        }
        if (StringUtils.isNotBlank((String)jndiLocation) && StringUtils.isNotBlank((String)resourceRefName)) {
            JNDIResourceModel resource = jndiResourceService.createUnique(jndiLocation);
            LOG.info("JNDI Name: " + jndiLocation + " to Resource: " + resourceRefName);
            for (EnvironmentReferenceModel ref : envRefService.findAllByProperty("name", resourceRefName)) {
                envRefService.associateEnvironmentToJndi(resource, ref);
            }
        }
    }
}

