/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.resource.transaction.file;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.transaction.ResourceTransactionListener;
import org.jboss.forge.addon.resource.transaction.file.FileResourceTransactionImpl;
import org.jboss.forge.furnace.container.cdi.events.Local;
import org.jboss.forge.furnace.event.PreShutdown;
import org.jboss.forge.furnace.spi.ListenerRegistration;

@Singleton
public class FileResourceTransactionManager {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private FileResourceTransactionImpl transaction;
    private final List<ResourceTransactionListener> listeners = new CopyOnWriteArrayList<ResourceTransactionListener>();

    public void shutdown(@Observes @Local PreShutdown shutdown) {
        if (this.transaction != null) {
            try {
                this.transaction.close();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Error while shutting down XAFileSystem", e);
            }
        }
    }

    @Produces
    public FileResourceTransactionImpl getCurrentTransaction(ResourceFactory resourceFactory) {
        if (this.transaction == null) {
            this.transaction = new FileResourceTransactionImpl(this, resourceFactory);
        }
        return this.transaction;
    }

    public ListenerRegistration<ResourceTransactionListener> addTransactionListener(final ResourceTransactionListener listener) {
        this.listeners.add(listener);
        return new ListenerRegistration<ResourceTransactionListener>(){

            public ResourceTransactionListener removeListener() {
                FileResourceTransactionManager.this.listeners.remove(listener);
                return listener;
            }
        };
    }

    public List<ResourceTransactionListener> getTransactionListeners() {
        return this.listeners;
    }
}

