/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.addon.ui.annotation.Command;
import org.jboss.forge.addon.ui.annotation.Option;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.impl.annotation.ReservedParameters;
import org.jboss.forge.addon.ui.impl.input.InputComponentProducer;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.SelectComponent;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.util.Predicate;

public class AnnotationCommandAdapter
implements UICommand {
    private final List<InputComponent<?, ?>> inputs = new ArrayList();
    private final InputComponentProducer factory;
    private final Method method;
    private final Object instance;
    private final List<Predicate<UIContext>> enabledPredicates;

    public AnnotationCommandAdapter(Method method, Object instance, InputComponentProducer factory, List<Predicate<UIContext>> enabledPredicates) {
        this.method = method;
        this.instance = instance;
        this.factory = factory;
        this.enabledPredicates = enabledPredicates;
    }

    public UICommandMetadata getMetadata(UIContext context) {
        Command ann = this.method.getAnnotation(Command.class);
        String name = ann.value();
        if (name.isEmpty()) {
            name = this.method.getName();
        }
        return Metadata.forCommand(this.method.getDeclaringClass()).name(name).description(ann.help()).category(Categories.create((String[])ann.categories()));
    }

    public boolean isEnabled(UIContext context) {
        boolean enabled = true;
        for (int i = 0; enabled && i < this.enabledPredicates.size(); enabled &= this.enabledPredicates.get(i).accept((Object)context), ++i) {
        }
        return enabled;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        int position = 0;
        for (Class<?> parameterType : this.method.getParameterTypes()) {
            if (!ReservedParameters.isReservedParameter(parameterType)) {
                Option option = null;
                for (Annotation annotation : this.method.getParameterAnnotations()[position]) {
                    if (!(annotation instanceof Option)) continue;
                    option = (Option)annotation;
                }
                if (option != null) {
                    UIInputMany<?> input;
                    String paramName;
                    char shortName = option.shortName();
                    String string = paramName = option.value().isEmpty() ? "param" + position : option.value();
                    if (Iterable.class.isAssignableFrom(parameterType)) {
                        input = this.factory.createInputMany(paramName, shortName, parameterType);
                    } else if (parameterType.isEnum() || Boolean.class == parameterType) {
                        input = this.factory.createSelectOne(paramName, shortName, parameterType);
                        this.factory.setupSelectComponent((SelectComponent)input);
                    } else {
                        input = this.factory.createInput(paramName, shortName, parameterType);
                    }
                    this.factory.preconfigureInput((InputComponent<?, ?>)input, option);
                    builder.add(input);
                    this.inputs.add((InputComponent<?, ?>)input);
                }
            }
            ++position;
        }
    }

    public void validate(UIValidationContext validator) {
    }

    public Result execute(UIExecutionContext context) throws Exception {
        ArrayList<Object> args = new ArrayList<Object>();
        int idx = 0;
        for (Class<?> type : this.method.getParameterTypes()) {
            Object value = null;
            if (ReservedParameters.isReservedParameter(type)) {
                value = ReservedParameters.getReservedParameter(context, type);
            } else {
                Option option = null;
                for (Annotation annotation : this.method.getParameterAnnotations()[args.size()]) {
                    if (!(annotation instanceof Option)) continue;
                    option = (Option)annotation;
                }
                if (option != null) {
                    value = InputComponents.getValueFor(this.inputs.get(idx));
                    ++idx;
                }
            }
            args.add(value);
        }
        Object result = null;
        try {
            result = this.method.invoke(this.instance, args.toArray(new Object[args.size()]));
        }
        catch (InvocationTargetException ie) {
            throw (Exception)ie.getCause();
        }
        if (result == null) {
            return Results.success();
        }
        if (result instanceof Result) {
            return (Result)result;
        }
        return Results.success((String)result.toString());
    }
}

