/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.SortedSet;
import org.jboss.tattletale.reporting.Report;
import org.jboss.tattletale.reporting.ReportSeverity;
import org.jboss.tattletale.reporting.ReportStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dump {
    private static final String NEW_LINE = System.getProperty("line.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateCSS(String outputDir) {
        byte[] buffer = new byte[8192];
        InputStream is = null;
        OutputStream os = null;
        try {
            int bytesRead;
            is = Dump.class.getClassLoader().getResourceAsStream("style.css");
            os = new FileOutputStream(outputDir + "style.css");
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.flush();
        }
        catch (Exception e) {
            System.err.println("GenerateCSS: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public static void generateIndex(SortedSet<Report> dependenciesReports, SortedSet<Report> generalReports, SortedSet<Report> archiveReports, SortedSet<Report> customReports, String outputDir) {
        try {
            FileWriter fw = new FileWriter(outputDir + "index.html");
            BufferedWriter bw = new BufferedWriter(fw, 8192);
            bw.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\"http://www.w3.org/TR/html4/loose.dtd\">" + Dump.newLine());
            bw.write("<html>" + Dump.newLine());
            bw.write("<head>" + Dump.newLine());
            bw.write("  <title>JBoss Tattletale 1.2.0.Beta2: Index</title>" + Dump.newLine());
            bw.write("  <meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">" + Dump.newLine());
            bw.write("  <link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\">" + Dump.newLine());
            bw.write("</head>" + Dump.newLine());
            bw.write("<body>" + Dump.newLine());
            bw.write(Dump.newLine());
            bw.write("<h1>JBoss Tattletale 1.2.0.Beta2</h1>" + Dump.newLine());
            Dump.generateReportItems(bw, dependenciesReports, "Dependencies", false);
            Dump.generateReportItems(bw, generalReports, "Reports", false);
            Dump.generateReportItems(bw, archiveReports, "Archives", true);
            Dump.generateReportItems(bw, customReports, "Custom reports", false);
            bw.write(Dump.newLine());
            bw.write("<p>" + Dump.newLine());
            bw.write("<hr>" + Dump.newLine());
            bw.write("Generated by: <a href=\"http://www.jboss.org/tattletale\">JBoss Tattletale 1.2.0.Beta2</a>" + Dump.newLine());
            bw.write(Dump.newLine());
            bw.write("</body>" + Dump.newLine());
            bw.write("</html>" + Dump.newLine());
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            System.err.println("GenerateIndex: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public static String newLine() {
        return NEW_LINE;
    }

    private static void generateReportItems(BufferedWriter bw, SortedSet<Report> reports, String heading, boolean useReportName) throws IOException {
        if (reports != null && reports.size() > 0) {
            bw.write("<h2>" + heading + "</h2>" + Dump.newLine());
            bw.write("<ul>" + Dump.newLine());
            String fileBase = "index";
            for (Report r : reports) {
                bw.write("<li>");
                if (useReportName) {
                    fileBase = r.getName();
                }
                bw.write("<a href=\"" + r.getDirectory() + "/" + fileBase + ".html\">" + r.getName() + "</a> (");
                bw.write("<span");
                bw.write(" style=\"color: " + ReportStatus.getStatusColor(r.getStatus()) + ";\"");
                bw.write(">");
                bw.write(ReportSeverity.getSeverityString(r.getSeverity()));
                bw.write("</span>");
                bw.write(") (" + Dump.getIndexHtmlSize(r) + ")</li>" + Dump.newLine());
            }
            bw.write("</ul>" + Dump.newLine());
        }
    }

    private static String getIndexHtmlSize(Report r) {
        File indexFile = new File(r.getOutputDirectory().getAbsolutePath() + File.separator + r.getIndexName());
        return indexFile.length() / 1024L + 1L + "KB";
    }
}

