/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.ast.java.data;

import org.jboss.windup.ast.java.data.ResolutionStatus;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;

public class ClassReference {
    private final String qualifiedName;
    private final ResolutionStatus resolutionStatus;
    private final int lineNumber;
    private final int column;
    private final int length;
    private final TypeReferenceLocation location;
    private String line;

    public ClassReference(String qualifiedName, ResolutionStatus resolutionStatus, TypeReferenceLocation location, int lineNumber, int column, int length, String line) {
        this.qualifiedName = qualifiedName;
        this.resolutionStatus = resolutionStatus;
        this.location = location;
        this.lineNumber = lineNumber;
        this.column = column;
        this.length = length;
        this.line = line;
    }

    public String getLine() {
        return this.line;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLength() {
        return this.length;
    }

    public TypeReferenceLocation getLocation() {
        return this.location;
    }

    public ResolutionStatus getResolutionStatus() {
        return this.resolutionStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassReference that = (ClassReference)o;
        if (this.lineNumber != that.lineNumber) {
            return false;
        }
        if (this.column != that.column) {
            return false;
        }
        if (this.length != that.length) {
            return false;
        }
        if (this.qualifiedName != null ? !this.qualifiedName.equals(that.qualifiedName) : that.qualifiedName != null) {
            return false;
        }
        if (this.resolutionStatus != that.resolutionStatus) {
            return false;
        }
        if (this.location != that.location) {
            return false;
        }
        return !(this.line == null ? that.line != null : !this.line.equals(that.line));
    }

    public int hashCode() {
        int result = this.qualifiedName != null ? this.qualifiedName.hashCode() : 0;
        result = 31 * result + (this.resolutionStatus != null ? this.resolutionStatus.hashCode() : 0);
        result = 31 * result + this.lineNumber;
        result = 31 * result + this.column;
        result = 31 * result + this.length;
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.line != null ? this.line.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClassReference [qualifiedName=" + this.qualifiedName + ", resolve status=" + (Object)((Object)this.resolutionStatus) + ", lineNumber=" + this.lineNumber + ", column=" + this.column + ", length=" + this.length + ", location=" + (Object)((Object)this.location) + ", line=" + this.line + "]";
    }
}

