/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools;

import java.util.Random;
import java.util.UUID;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.XMLSchema;

public class RandomValueFactory {
    private static final int MAXINT = 65535;
    private static final int MIN_LABEL_LENGTH = 1;
    private static final int MAX_LABEL_LENGTH = 100;
    private static final String[] languages = new String[]{"en", "fr", "de"};
    private ValueFactory valueFactory;
    private Random rand = new Random();

    public RandomValueFactory(ValueFactory vf) {
        this.valueFactory = vf;
    }

    public Statement randomStatement() {
        return this.randomStatement(this.randomResource());
    }

    public Statement randomStatement(Resource context) {
        Resource subj = this.randomResource();
        URI pred = this.randomURI();
        Value obj = this.randomValue();
        return this.valueFactory.createStatement(subj, pred, obj, context);
    }

    public Resource randomResource() {
        ValueType type;
        while (ValueType.Literal == (type = this.randomValueType())) {
        }
        return (Resource)this.randomValue(type);
    }

    public Value randomValue() {
        ValueType type = this.randomValueType();
        return this.randomValue(type);
    }

    public URI randomURI() {
        return this.valueFactory.createURI("urn:uuid:" + UUID.randomUUID().toString().replace("-", ""));
    }

    public BNode randomBNode() {
        return this.valueFactory.createBNode();
    }

    public Literal randomLiteral() {
        LiteralKind kind = LiteralKind.values()[this.rand.nextInt(65535) % LiteralKind.values().length];
        Literal l = null;
        switch (kind) {
            case Plain: {
                l = this.valueFactory.createLiteral(this.randomStringLabel());
                break;
            }
            case WithLanguage: {
                l = this.valueFactory.createLiteral(this.randomStringLabel(), this.randomLanguage());
                break;
            }
            case Typed: {
                l = this.randomTypedLiteral();
            }
        }
        return l;
    }

    public Literal randomTypedLiteral() {
        LiteralType type = LiteralType.values()[this.rand.nextInt(65535) % LiteralType.values().length];
        Literal l = null;
        switch (type) {
            case Int: {
                l = this.valueFactory.createLiteral(this.rand.nextInt(65535));
                break;
            }
            case Double: {
                l = this.valueFactory.createLiteral(this.rand.nextDouble());
                break;
            }
            case String: {
                l = this.valueFactory.createLiteral(this.randomStringLabel(), XMLSchema.STRING);
            }
        }
        return l;
    }

    private ValueType randomValueType() {
        return ValueType.values()[this.rand.nextInt(65535) % ValueType.values().length];
    }

    private Value randomValue(ValueType type) {
        URI v = null;
        switch (type) {
            case Uri: {
                v = this.randomURI();
                break;
            }
            case Literal: {
                v = this.randomLiteral();
            }
        }
        return v;
    }

    private String randomLanguage() {
        return languages[this.rand.nextInt(65535) % languages.length];
    }

    private String randomLabel(int minlen, int maxlen) {
        int n = minlen + this.rand.nextInt(maxlen - minlen);
        byte[] b = new byte[n];
        int range = 94;
        for (int i = 0; i < n; ++i) {
            b[i] = (byte)(32 + this.rand.nextInt(range));
        }
        return new String(b);
    }

    private String randomStringLabel() {
        return this.randomLabel(1, 100);
    }

    private static enum LiteralType {
        String,
        Int,
        Double;

    }

    private static enum LiteralKind {
        Plain,
        WithLanguage,
        Typed;

    }

    private static enum ValueType {
        Uri,
        Literal;

    }
}

