/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules.generation;

import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CreateMigrationIssuesReportRuleProvider
extends AbstractRuleProvider {
    public static final String TEMPLATE_PATH = "/reports/templates/migration-issues.ftl";

    public CreateMigrationIssuesReportRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(CreateMigrationIssuesReportRuleProvider.class).setPhase(ReportGenerationPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        return ConfigurationBuilder.begin().addRule().perform((Operation)new CreateProblemCentricReportOperation());
    }

    private class CreateProblemCentricReportOperation
    extends GraphOperation {
        private CreateProblemCentricReportOperation() {
        }

        public void perform(GraphRewrite event, EvaluationContext context) {
            ApplicationReportService applicationReportService = new ApplicationReportService(event.getGraphContext());
            ApplicationReportModel report = applicationReportService.create();
            report.setReportPriority(110);
            report.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
            report.setReportIconClass("glyphicon glyphicon-warning-sign");
            report.setReportName("Migration Issues");
            report.setTemplatePath(CreateMigrationIssuesReportRuleProvider.TEMPLATE_PATH);
            report.setTemplateType(TemplateType.FREEMARKER);
            ProjectModel projectModel = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext()).getInputPath().getProjectModel();
            report.setProjectModel(projectModel);
            ReportService reportService = new ReportService(event.getGraphContext());
            reportService.setUniqueFilename((ReportModel)report, "problem_centric_report", "html");
        }
    }
}

