/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.util;

import java.util.List;
import org.ocpsoft.common.pattern.Weighted;
import org.ocpsoft.logging.Logger;

public final class ServiceLogger {
    public static <T> void logLoadedServices(Logger log, Class<T> type, List<? extends T> services) {
        log.info("Loaded [" + services.size() + "] " + type.getName() + " [" + ServiceLogger.joinTypeNames(services) + "]");
    }

    private static String joinTypeNames(List<?> list) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Object service = list.get(i);
            result.append(service.getClass().getName());
            if (service instanceof Weighted) {
                result.append("<" + ((Weighted)service).priority() + ">");
            }
            if (i + 1 >= list.size()) continue;
            result.append(", ");
        }
        return result.toString();
    }
}

