/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.websphere;

import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.xml.DiscoverXmlFilesRuleProvider;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class ResolveWebsphereWsClientBindingXmlRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(ResolveWebsphereWsClientBindingXmlRuleProvider.class.getSimpleName());

    public ResolveWebsphereWsClientBindingXmlRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(ResolveWebsphereWsClientBindingXmlRuleProvider.class).setPhase(InitialAnalysisPhase.class).addExecuteAfter(DiscoverXmlFilesRuleProvider.class));
    }

    public String toStringPerform() {
        return "Discover Websphere Web Service Binding XML Files";
    }

    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("fileName", (Object)"ibm-webservices-ext.xmi").withProperty("rootTagName", (Object)"WsExtension");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        ClassificationService classificationService = new ClassificationService(event.getGraphContext());
        classificationService.attachClassification(context, (FileModel)payload, "Websphere WS Client", "Websphere Webservice Binding XML Descriptor.");
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        technologyTagService.addTagToFileModel((FileModel)payload, "Websphere WS Client", TechnologyTagLevel.IMPORTANT);
    }
}

