/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.ui;

import java.util.TreeSet;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.manager.impl.ui.AddonCommandConstants;
import org.jboss.forge.addon.manager.impl.utils.CoordinateUtils;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.Projects;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.validate.UIValidator;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.manager.AddonManager;
import org.jboss.forge.furnace.manager.spi.AddonDependencyResolver;
import org.jboss.forge.furnace.util.Strings;

public class AddonInstallCommand
extends AbstractUICommand
implements AddonCommandConstants {
    private static final String FORGE_ADDON_GROUP_ID = "org.jboss.forge.addon:";
    @Inject
    private AddonManager addonManager;
    @Inject
    private AddonDependencyResolver resolver;
    @Inject
    @WithAttributes(label="Coordinate", description="The addon's \"groupId:artifactId,version\" coordinate", note="The addon's \"groupId:artifactId,version\" coordinate", required=true)
    private UIInput<String> coordinate;
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    private Furnace furnace;

    public Metadata getMetadata(UIContext context) {
        boolean gui = context.getProvider().isGUI();
        return Metadata.from((UICommandMetadata)super.getMetadata(context), this.getClass()).name(gui ? "Install an Addon" : "addon-install").description("Command to install a Furnace 2 addon.").category(Categories.create((String[])ADDON_MANAGER_CATEGORIES));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = Projects.getSelectedProject((ProjectFactory)this.projectFactory, (UIContext)builder.getUIContext());
        if (project != null) {
            MetadataFacet facet = (MetadataFacet)project.getFacet(MetadataFacet.class);
            Coordinate c = facet.getOutputDependency().getCoordinate();
            this.coordinate.setDefaultValue((Object)AddonId.from((String)(c.getGroupId() + ":" + c.getArtifactId()), (String)c.getVersion()).toCoordinates());
        }
        this.coordinate.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                TreeSet<String> items = new TreeSet<String>();
                if (Strings.isNullOrEmpty((String)value)) {
                    items.add(AddonInstallCommand.FORGE_ADDON_GROUP_ID);
                }
                return items;
            }
        });
        this.coordinate.addValidator(new UIValidator(){

            public void validate(UIValidationContext context) {
                String coordinate = (String)context.getCurrentInputComponent().getValue();
                try {
                    CoordinateUtils.resolveCoordinate(coordinate, AddonInstallCommand.this.furnace.getVersion(), AddonInstallCommand.this.resolver);
                }
                catch (Exception e) {
                    context.addValidationError(context.getCurrentInputComponent(), "\"" + coordinate + "\" is not a valid Addon coordinate");
                }
            }
        });
        builder.add(this.coordinate);
    }

    public Result execute(UIExecutionContext context) {
        AddonId addonId = CoordinateUtils.resolveCoordinate((String)this.coordinate.getValue(), this.furnace.getVersion(), this.resolver);
        try {
            this.addonManager.install(addonId).perform();
            return Results.success((String)("Addon " + addonId.toCoordinates() + " was installed successfully."));
        }
        catch (Throwable t) {
            return Results.fail((String)("Addon " + addonId.toCoordinates() + " could not be installed."), (Throwable)t);
        }
    }
}

