/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PagedGrowableWriter;
import org.apache.lucene.util.packed.PagedMutable;

class BinaryDocValuesFieldUpdates
extends DocValuesFieldUpdates {
    private FixedBitSet docsWithField = new FixedBitSet(64);
    private PagedMutable docs;
    private PagedGrowableWriter offsets;
    private PagedGrowableWriter lengths;
    private BytesRef values;
    private int size;

    public BinaryDocValuesFieldUpdates(String field, int maxDoc) {
        super(field, DocValuesFieldUpdates.Type.BINARY);
        this.docs = new PagedMutable(1L, 1024, PackedInts.bitsRequired(maxDoc - 1), 0.0f);
        this.offsets = new PagedGrowableWriter(1L, 1024, 1, 0.5f);
        this.lengths = new PagedGrowableWriter(1L, 1024, 1, 0.5f);
        this.values = new BytesRef(16);
        this.size = 0;
    }

    @Override
    public void add(int doc, Object value) {
        if (this.size == Integer.MAX_VALUE) {
            throw new IllegalStateException("cannot support more than Integer.MAX_VALUE doc/value entries");
        }
        BytesRef val = (BytesRef)value;
        if (val == null) {
            val = DocValuesUpdate.BinaryDocValuesUpdate.MISSING;
        }
        if (this.docs.size() == (long)this.size) {
            this.docs = (PagedMutable)this.docs.grow(this.size + 1);
            this.offsets = (PagedGrowableWriter)this.offsets.grow(this.size + 1);
            this.lengths = (PagedGrowableWriter)this.lengths.grow(this.size + 1);
            this.docsWithField = FixedBitSet.ensureCapacity(this.docsWithField, (int)this.docs.size());
        }
        if (val != DocValuesUpdate.BinaryDocValuesUpdate.MISSING) {
            this.docsWithField.set(this.size);
        }
        this.docs.set(this.size, doc);
        this.offsets.set(this.size, this.values.length);
        this.lengths.set(this.size, val.length);
        this.values.append(val);
        ++this.size;
    }

    @Override
    public Iterator iterator() {
        final PagedMutable docs = this.docs;
        final PagedGrowableWriter offsets = this.offsets;
        final PagedGrowableWriter lengths = this.lengths;
        BytesRef values = this.values;
        final FixedBitSet docsWithField = this.docsWithField;
        new InPlaceMergeSorter(){

            @Override
            protected void swap(int i, int j) {
                long tmpDoc = docs.get(j);
                docs.set(j, docs.get(i));
                docs.set(i, tmpDoc);
                long tmpOffset = offsets.get(j);
                offsets.set(j, offsets.get(i));
                offsets.set(i, tmpOffset);
                long tmpLength = lengths.get(j);
                lengths.set(j, lengths.get(i));
                lengths.set(i, tmpLength);
                boolean tmpBool = docsWithField.get(j);
                if (docsWithField.get(i)) {
                    docsWithField.set(j);
                } else {
                    docsWithField.clear(j);
                }
                if (tmpBool) {
                    docsWithField.set(i);
                } else {
                    docsWithField.clear(i);
                }
            }

            @Override
            protected int compare(int i, int j) {
                int y;
                int x = (int)docs.get(i);
                return x < (y = (int)docs.get(j)) ? -1 : (x == y ? 0 : 1);
            }
        }.sort(0, this.size);
        return new Iterator(this.size, offsets, lengths, docs, values, docsWithField);
    }

    @Override
    public void merge(DocValuesFieldUpdates other) {
        BinaryDocValuesFieldUpdates otherUpdates = (BinaryDocValuesFieldUpdates)other;
        int newSize = this.size + otherUpdates.size;
        if (newSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("cannot support more than Integer.MAX_VALUE doc/value entries; size=" + this.size + " other.size=" + otherUpdates.size);
        }
        this.docs = (PagedMutable)this.docs.grow(newSize);
        this.offsets = (PagedGrowableWriter)this.offsets.grow(newSize);
        this.lengths = (PagedGrowableWriter)this.lengths.grow(newSize);
        this.docsWithField = FixedBitSet.ensureCapacity(this.docsWithField, (int)this.docs.size());
        for (int i = 0; i < otherUpdates.size; ++i) {
            int doc = (int)otherUpdates.docs.get(i);
            if (otherUpdates.docsWithField.get(i)) {
                this.docsWithField.set(this.size);
            }
            this.docs.set(this.size, doc);
            this.offsets.set(this.size, (long)this.values.length + otherUpdates.offsets.get(i));
            this.lengths.set(this.size, otherUpdates.lengths.get(i));
            ++this.size;
        }
        this.values.append(otherUpdates.values);
    }

    @Override
    public boolean any() {
        return this.size > 0;
    }

    static final class Iterator
    extends DocValuesFieldUpdates.Iterator {
        private final PagedGrowableWriter offsets;
        private final int size;
        private final PagedGrowableWriter lengths;
        private final PagedMutable docs;
        private final FixedBitSet docsWithField;
        private long idx = 0L;
        private int doc = -1;
        private final BytesRef value;
        private int offset;
        private int length;

        Iterator(int size, PagedGrowableWriter offsets, PagedGrowableWriter lengths, PagedMutable docs, BytesRef values, FixedBitSet docsWithField) {
            this.offsets = offsets;
            this.size = size;
            this.lengths = lengths;
            this.docs = docs;
            this.docsWithField = docsWithField;
            this.value = values.clone();
        }

        @Override
        BytesRef value() {
            if (this.offset == -1) {
                return null;
            }
            this.value.offset = this.offset;
            this.value.length = this.length;
            return this.value;
        }

        @Override
        int nextDoc() {
            if (this.idx >= (long)this.size) {
                this.offset = -1;
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = (int)this.docs.get(this.idx);
            ++this.idx;
            while (this.idx < (long)this.size && this.docs.get(this.idx) == (long)this.doc) {
                ++this.idx;
            }
            long prevIdx = this.idx - 1L;
            if (!this.docsWithField.get((int)prevIdx)) {
                this.offset = -1;
            } else {
                this.offset = (int)this.offsets.get(prevIdx);
                this.length = (int)this.lengths.get(prevIdx);
            }
            return this.doc;
        }

        @Override
        int doc() {
            return this.doc;
        }

        @Override
        void reset() {
            this.doc = -1;
            this.offset = -1;
            this.idx = 0L;
        }
    }
}

