/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.frames.annotations.gremlin;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.ClassUtilities;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.annotations.AnnotationHandler;
import com.tinkerpop.frames.annotations.gremlin.GremlinGroovy;
import com.tinkerpop.frames.annotations.gremlin.GremlinParam;
import com.tinkerpop.frames.modules.MethodHandler;
import com.tinkerpop.frames.structures.FramedVertexIterable;
import com.tinkerpop.frames.structures.FramedVertexMap;
import com.tinkerpop.frames.util.ExceptionUtils;
import com.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.iterators.SingleIterator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptException;

public class GremlinGroovyAnnotationHandler
implements AnnotationHandler<GremlinGroovy>,
MethodHandler<GremlinGroovy> {
    private static final String PIPE = "_()";
    private final GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine();
    private static final String IT = "it";
    private static final String G = "g";
    private static final Logger LOGGER = Logger.getLogger(GremlinGroovyAnnotationHandler.class.getName());

    public GremlinGroovyScriptEngine getGremlinScriptEngine() {
        return this.engine;
    }

    @Override
    public Class<GremlinGroovy> getAnnotationType() {
        return GremlinGroovy.class;
    }

    @Override
    public Object processElement(GremlinGroovy annotation, Method method, Object[] arguments, FramedGraph framedGraph, Element element, Direction direction) {
        if (element instanceof Vertex) {
            return this.processVertex(annotation, method, arguments, framedGraph, (Vertex)element);
        }
        throw new UnsupportedOperationException("This method only works for vertices");
    }

    public Object processVertex(GremlinGroovy annotation, Method method, Object[] arguments, FramedGraph framedGraph, Vertex vertex) {
        try {
            CompiledScript script = this.engine.compile(annotation.value());
            Bindings bindings = this.getBindings(method, arguments);
            bindings.put(IT, (Object)vertex);
            bindings.put(G, (Object)framedGraph);
            Object result = script.eval(bindings);
            if (result instanceof Pipe & annotation.value().startsWith(PIPE)) {
                LOGGER.warning("_() is deprecated in favor of using 'it' to represent the framed vertex");
                ((Pipe)result).setStarts((Iterator)new SingleIterator((Object)vertex));
            }
            if (annotation.frame()) {
                if (result instanceof Iterable) {
                    FramedVertexIterable r = new FramedVertexIterable(framedGraph, (Iterable)result, ClassUtilities.getGenericClass(method));
                    return ClassUtilities.returnsIterable(method) ? r : (r.iterator().hasNext() ? r.iterator().next() : null);
                }
                if (ClassUtilities.returnsMap(method)) {
                    return new FramedVertexMap(framedGraph, (Map)result, ClassUtilities.getGenericClass(method));
                }
                if (result instanceof Vertex) {
                    return framedGraph.frame((Vertex)result, ClassUtilities.getGenericClass(method));
                }
                throw new IllegalStateException("The returned object can not be framed: " + result.getClass());
            }
            return result;
        }
        catch (ScriptException e) {
            ExceptionUtils.sneakyThrow(e);
            return null;
        }
    }

    private Bindings getBindings(Method method, Object[] arguments) {
        Bindings bindings = this.engine.createBindings();
        Annotation[][] allParameterAnnotations = method.getParameterAnnotations();
        block0: for (int pCount = 0; pCount < allParameterAnnotations.length; ++pCount) {
            Annotation[] parameterAnnotations = allParameterAnnotations[pCount];
            for (int aCount = 0; aCount < parameterAnnotations.length; ++aCount) {
                Annotation paramAnnotation = parameterAnnotations[aCount];
                if (!(paramAnnotation instanceof GremlinParam)) continue;
                bindings.put(((GremlinParam)paramAnnotation).value(), arguments[pCount]);
                continue block0;
            }
        }
        return bindings;
    }

    @Override
    public Object processElement(Object framedElement, Method method, Object[] arguments, GremlinGroovy annotation, FramedGraph<?> framedGraph, Element element) {
        if (element instanceof Vertex) {
            return this.processVertex(annotation, method, arguments, framedGraph, (Vertex)element);
        }
        throw new UnsupportedOperationException("This method only works for vertices");
    }
}

