/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.configuration.backend;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.diskstorage.util.time.Durations;
import com.thinkaurelius.titan.diskstorage.util.time.StandardDuration;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonsConfiguration
implements WriteConfiguration {
    private final Configuration config;
    private static final Logger log = LoggerFactory.getLogger(CommonsConfiguration.class);

    public CommonsConfiguration() {
        this((Configuration)new BaseConfiguration());
    }

    public CommonsConfiguration(Configuration config) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0);
        this.config = config;
    }

    public Configuration getCommonConfiguration() {
        return this.config;
    }

    @Override
    public <O> O get(String key, Class<O> datatype) {
        if (!this.config.containsKey(key)) {
            return null;
        }
        if (datatype.isArray()) {
            Preconditions.checkArgument((datatype.getComponentType() == String.class ? 1 : 0) != 0, (String)"Only string arrays are supported: %s", (Object[])new Object[]{datatype});
            return (O)this.config.getStringArray(key);
        }
        if (Number.class.isAssignableFrom(datatype)) {
            Object o = this.config.getProperty(key);
            if (datatype.isInstance(o)) {
                return (O)o;
            }
            return this.constructFromStringArgument(datatype, o.toString());
        }
        if (datatype == String.class) {
            return (O)this.config.getString(key);
        }
        if (datatype == Boolean.class) {
            return (O)new Boolean(this.config.getBoolean(key));
        }
        if (datatype.isEnum()) {
            Enum[] constants = (Enum[])datatype.getEnumConstants();
            Preconditions.checkState((null != constants && 0 < constants.length ? 1 : 0) != 0, (Object)"Zero-length or undefined enum");
            String estr = this.config.getProperty(key).toString();
            for (Enum ec : constants) {
                if (!ec.toString().equals(estr)) continue;
                return (O)ec;
            }
            throw new IllegalArgumentException("No match for string \"" + estr + "\" in enum " + datatype);
        }
        if (datatype == Object.class) {
            return (O)this.config.getProperty(key);
        }
        if (Duration.class.isAssignableFrom(datatype)) {
            Object o = this.config.getProperty(key);
            if (Duration.class.isInstance(o)) {
                return (O)o;
            }
            String[] comps = o.toString().split("\\s");
            TimeUnit unit = null;
            if (comps.length == 1) {
                unit = TimeUnit.MILLISECONDS;
            } else if (comps.length == 2) {
                unit = Durations.parse(comps[1]);
            } else {
                throw new IllegalArgumentException("Cannot parse time duration from: " + o.toString());
            }
            return (O)new StandardDuration(Long.valueOf(comps[0]), unit);
        }
        throw new IllegalArgumentException("Unsupported data type: " + datatype);
    }

    private <O> O constructFromStringArgument(Class<O> datatype, String arg) {
        try {
            Constructor<O> ctor = datatype.getConstructor(String.class);
            return ctor.newInstance(arg);
        }
        catch (Exception e) {
            log.error("Failed to parse configuration string \"{}\" into type {} due to the following reflection exception", new Object[]{arg, datatype, e});
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterable<String> getKeys(String prefix) {
        ArrayList result = Lists.newArrayList();
        Iterator keys = StringUtils.isNotBlank((String)prefix) ? this.config.getKeys(prefix) : this.config.getKeys();
        while (keys.hasNext()) {
            result.add(keys.next());
        }
        return result;
    }

    @Override
    public void close() {
    }

    @Override
    public <O> void set(String key, O value) {
        if (value == null) {
            this.config.clearProperty(key);
        } else {
            this.config.setProperty(key, value);
        }
    }

    @Override
    public void remove(String key) {
        this.config.clearProperty(key);
    }

    @Override
    public WriteConfiguration copy() {
        BaseConfiguration copy = new BaseConfiguration();
        copy.copy(this.config);
        return new CommonsConfiguration((Configuration)copy);
    }
}

