/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.log.kcvs;

import com.google.common.collect.Lists;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.CacheTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.KCVSCache;
import com.thinkaurelius.titan.diskstorage.log.kcvs.ExternalPersistor;

public class ExternalCachePersistor
implements ExternalPersistor {
    private final KCVSCache kcvs;
    private final CacheTransaction tx;

    public ExternalCachePersistor(KCVSCache kcvs, CacheTransaction tx) {
        this.kcvs = kcvs;
        this.tx = tx;
    }

    @Override
    public void add(StaticBuffer key, Entry cell) {
        try {
            this.kcvs.mutateEntries(key, Lists.newArrayList((Object[])new Entry[]{cell}), KCVSCache.NO_DELETIONS, this.tx);
        }
        catch (BackendException e) {
            throw new TitanException("Unexpected storage exception in log persistence against cache", e);
        }
    }
}

