/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.freemarker;

import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.ReportResourceFileModel;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.util.ExecutionStatistics;

public class GetPrettyPathForFile
implements WindupFreeMarkerMethod {
    private static final String NAME = "getPrettyPathForFile";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        try {
            if (arguments.size() != 1) {
                throw new TemplateModelException("Error, method expects one argument (FileModel)");
            }
            StringModel stringModelArg = (StringModel)arguments.get(0);
            FileModel fileModel = (FileModel)stringModelArg.getWrappedObject();
            if (fileModel instanceof JavaClassFileModel) {
                JavaClassFileModel jcfm = (JavaClassFileModel)fileModel;
                String string = jcfm.getJavaClass().getQualifiedName();
                return string;
            }
            if (fileModel instanceof ReportResourceFileModel) {
                String jcfm = "resources/" + fileModel.getPrettyPath();
                return jcfm;
            }
            if (fileModel instanceof JavaSourceFileModel) {
                JavaSourceFileModel javaSourceModel = (JavaSourceFileModel)fileModel;
                String filename = fileModel.getFileName();
                String packageName = javaSourceModel.getPackageName();
                if (filename.endsWith(".java")) {
                    filename = filename.substring(0, filename.length() - 5);
                }
                String string = packageName == null || packageName.equals("") ? filename : packageName + "." + filename;
                return string;
            }
            String string = fileModel.getPrettyPathWithinProject();
            return string;
        }
        finally {
            ExecutionStatistics.get().end(NAME);
        }
    }

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Takes a " + FileModel.class.getSimpleName() + " as a parameter and either the qualified name (if it is a Java file) or the path within the file's project.";
    }

    public void setContext(GraphRewrite event) {
    }
}

