/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.operation;

import com.thinkaurelius.titan.core.TitanGraph;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.jboss.forge.furnace.util.Streams;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.IgnoredFileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.rules.apps.java.archives.model.IdentifiedArchiveModel;
import org.jboss.windup.rules.apps.java.scan.operation.IdentifiedArchiveFileFilter;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.ZipUtil;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class UnzipArchiveToOutputFolder
extends AbstractIterationOperation<ArchiveModel> {
    private static final String MALFORMED_ARCHIVE = "Malformed archive";
    private static final String ARCHIVES = "archives";
    private static final Logger LOG = Logging.get(UnzipArchiveToOutputFolder.class);

    public UnzipArchiveToOutputFolder(String variableName) {
        super(variableName);
    }

    public UnzipArchiveToOutputFolder() {
    }

    public static UnzipArchiveToOutputFolder unzip(String variableName) {
        return new UnzipArchiveToOutputFolder(variableName);
    }

    public static UnzipArchiveToOutputFolder unzip() {
        return new UnzipArchiveToOutputFolder();
    }

    public void perform(GraphRewrite event, EvaluationContext context, ArchiveModel payload) {
        LOG.info("Unzipping archive: " + payload.toPrettyString());
        File zipFile = payload.asFile();
        if (zipFile == null || !zipFile.isFile()) {
            throw new WindupException("Input path doesn't point to a file: " + (zipFile == null ? "null" : zipFile.getAbsolutePath()));
        }
        WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
        String windupOutputFolder = cfg.getOutputPath().getFilePath();
        Path windupTempUnzippedArchiveFolder = Paths.get(windupOutputFolder, ARCHIVES);
        if (!Files.isDirectory(windupTempUnzippedArchiveFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(windupTempUnzippedArchiveFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new WindupException("Failed to create temporary folder: " + windupTempUnzippedArchiveFolder + " due to: " + e.getMessage(), (Throwable)e);
            }
        }
        this.unzipToTempDirectory(event, context, windupTempUnzippedArchiveFolder, zipFile, payload);
    }

    private Path getAppArchiveFolder(Path tempFolder, String appArchiveName) {
        Path appArchiveFolder = Paths.get(tempFolder.toString(), appArchiveName);
        int fileIdx = 1;
        while (Files.exists(appArchiveFolder, new LinkOption[0])) {
            appArchiveFolder = Paths.get(tempFolder.toString(), appArchiveName + "." + fileIdx);
            ++fileIdx;
        }
        return appArchiveFolder;
    }

    private void unzipToTempDirectory(GraphRewrite event, EvaluationContext context, Path tempFolder, File inputZipFile, ArchiveModel archiveModel) {
        FileService fileService = new FileService(event.getGraphContext());
        String appArchiveName = archiveModel.getArchiveName();
        if (null == appArchiveName) {
            throw new IllegalStateException("Archive model doesn't have an archiveName: " + archiveModel.getFilePath());
        }
        Path appArchiveFolder = this.getAppArchiveFolder(tempFolder, appArchiveName);
        try {
            Files.createDirectories(appArchiveFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new WindupException("Could not create a temporary directory for application \"" + appArchiveName + "\" at \"" + appArchiveFolder.toString() + "\" due to: " + e.getMessage(), (Throwable)e);
        }
        LOG.info("Unzipping " + inputZipFile.getPath() + " to " + appArchiveFolder.toString());
        try {
            this.unzipToFolder(inputZipFile, appArchiveFolder.toFile());
        }
        catch (Throwable e) {
            ClassificationService classificationService = new ClassificationService(event.getGraphContext());
            classificationService.attachClassification(context, (FileModel)archiveModel, MALFORMED_ARCHIVE, "Cannot unzip the file");
            LOG.warning("Cannot unzip the file " + inputZipFile.getPath() + " to " + appArchiveFolder.toString() + ". The ArchiveModel was classified as malformed.");
            return;
        }
        FileModel newFileModel = fileService.createByFilePath(appArchiveFolder.toString());
        archiveModel.setUnzippedDirectory(newFileModel);
        newFileModel.setParentArchive(archiveModel);
        this.recurseAndAddFiles(event, context, tempFolder, fileService, archiveModel, newFileModel);
    }

    private void unzipToFolder(File inputFile, File outputDir) throws IOException {
        if (inputFile == null) {
            throw new IllegalArgumentException("Argument inputFile is null.");
        }
        if (outputDir == null) {
            throw new IllegalArgumentException("Argument outputDir is null.");
        }
        try (ZipFile zipFile = new ZipFile(inputFile);){
            Enumeration<? extends ZipEntry> entryEnum = zipFile.entries();
            while (entryEnum.hasMoreElements()) {
                ZipEntry entry = entryEnum.nextElement();
                String entryName = entry.getName();
                File destFile = new File(outputDir, entryName);
                if (entry.isDirectory()) continue;
                File parentDir = destFile.getParentFile();
                if (!parentDir.isDirectory() && !parentDir.mkdirs()) {
                    throw new WindupException("Unable to create directory: " + parentDir.getAbsolutePath());
                }
                InputStream zipInputStream = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileOutputStream outputStream = new FileOutputStream(destFile);
                    Throwable throwable2 = null;
                    try {
                        Streams.write((InputStream)zipInputStream, (OutputStream)outputStream);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (outputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                outputStream.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                            continue;
                        }
                        outputStream.close();
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (zipInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            zipInputStream.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    zipInputStream.close();
                }
            }
        }
    }

    private void recurseAndAddFiles(GraphRewrite event, EvaluationContext context, Path tempFolder, FileService fileService, ArchiveModel archiveModel, FileModel parentFileModel) {
        File[] subFiles;
        int numberAdded = 0;
        Object filter = TrueFileFilter.TRUE;
        if (archiveModel instanceof IdentifiedArchiveModel) {
            filter = new IdentifiedArchiveFileFilter(archiveModel);
        }
        File fileReference = parentFileModel.asFile();
        WindupJavaConfigurationService windupJavaConfigurationService = new WindupJavaConfigurationService(event.getGraphContext());
        if (fileReference.isDirectory() && (subFiles = fileReference.listFiles()) != null) {
            for (File subFile : subFiles) {
                if (!filter.accept(subFile)) continue;
                FileModel subFileModel = fileService.createByFilePath(parentFileModel, subFile.getAbsolutePath());
                subFileModel.setParentArchive(archiveModel);
                if (this.checkIfIgnored(event.getGraphContext(), subFileModel, windupJavaConfigurationService.getIgnoredFileRegexes())) continue;
                if (++numberAdded % 250 == 0) {
                    ((TitanGraph)event.getGraphContext().getGraph().getBaseGraph()).commit();
                }
                if (subFile.isFile() && ZipUtil.endsWithZipExtension((String)subFileModel.getFilePath())) {
                    File newZipFile = subFileModel.asFile();
                    ArchiveModel newArchiveModel = (ArchiveModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)subFileModel, ArchiveModel.class);
                    newArchiveModel.setParentArchive(archiveModel);
                    newArchiveModel.setArchiveName(newZipFile.getName());
                    archiveModel.addChildArchive(newArchiveModel);
                    newArchiveModel = (ArchiveModel)GraphService.refresh((GraphContext)event.getGraphContext(), (WindupVertexFrame)newArchiveModel);
                    this.unzipToTempDirectory(event, context, tempFolder, newZipFile, newArchiveModel);
                }
                if (!subFile.isDirectory()) continue;
                this.recurseAndAddFiles(event, context, tempFolder, fileService, archiveModel, subFileModel);
            }
        }
    }

    private boolean checkIfIgnored(GraphContext context, FileModel file, List<String> patterns) {
        boolean ignored = false;
        if (patterns != null && patterns.size() != 0) {
            for (String pattern : patterns) {
                if (!file.getFilePath().matches(pattern)) continue;
                IgnoredFileModel ignoredFileModel = (IgnoredFileModel)GraphService.addTypeToModel((GraphContext)context, (WindupVertexFrame)file, IgnoredFileModel.class);
                ignoredFileModel.setIgnoredRegex(pattern);
                LOG.info("File/Directory placed in " + file.getFilePath() + " was ignored, because matched [" + pattern + "].");
                ignored = true;
                break;
            }
        }
        return ignored;
    }

    public String toString() {
        return "UnzipArchivesToOutputFolder";
    }
}

