/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.modules.MethodHandler;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.windup.graph.SetInProperties;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;

public class SetInPropertiesHandler
implements MethodHandler<SetInProperties> {
    private static final Logger log = Logging.get(SetInPropertiesHandler.class);
    private static final String SET_VERTEX_PROP_VALUE = "1";

    public Class<SetInProperties> getAnnotationType() {
        return SetInProperties.class;
    }

    public Object processElement(Object frame, Method method, Object[] args, SetInProperties ann, FramedGraph<?> framedGraph, Element elm) {
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            return this.handleGetter((Vertex)elm, method, args, ann, framedGraph);
        }
        if (methodName.startsWith("set")) {
            this.handleSetter((Vertex)elm, method, args, ann, framedGraph);
        } else if (methodName.startsWith("addAll")) {
            this.handleAddAll((Vertex)elm, method, args, ann, framedGraph);
        } else if (methodName.startsWith("add")) {
            this.handleAdder((Vertex)elm, method, args, ann, framedGraph);
        } else {
            throw new WindupException("Only get*, set*, add*, and addAll* method names are supported for @" + SetInProperties.class.getSimpleName() + ", found at: " + method.getName());
        }
        return frame;
    }

    private Set<String> handleGetter(Vertex vertex, Method method, Object[] args, SetInProperties ann, FramedGraph<?> framedGraph) {
        if (args != null && args.length != 0) {
            throw new WindupException("Method must take zero arguments");
        }
        HashSet<String> set = new HashSet<String>();
        String prefix = this.preparePrefix(ann);
        Set keys = vertex.getPropertyKeys();
        Iterator i$ = keys.iterator();
        while (i$.hasNext()) {
            String key;
            String tail = key = (String)i$.next();
            if (!prefix.isEmpty()) {
                if (!key.startsWith(prefix)) continue;
                tail = key.substring(prefix.length());
            }
            set.add(tail);
        }
        return set;
    }

    private void handleSetter(Vertex vertex, Method method, Object[] args, SetInProperties ann, FramedGraph<?> framedGraph) {
        if (args == null || args.length != 1) {
            throw new WindupException("Method must take one argument: " + method.getName());
        }
        if (!(args[0] instanceof Set)) {
            throw new WindupException("Argument of " + method.getName() + " must be a Set<String>, but is: " + args[0].getClass());
        }
        Set newSet = (Set)args[0];
        String prefix = this.preparePrefix(ann);
        Set vertKeys = vertex.getPropertyKeys();
        for (String vertKey : vertKeys) {
            if (!vertKey.startsWith(prefix) || "w:vertextype".equals(vertKey) || vertKey.startsWith("w:")) continue;
            String subKey = vertKey.substring(prefix.length());
            if (newSet.contains(subKey)) {
                vertex.setProperty(vertKey, (Object)SET_VERTEX_PROP_VALUE);
                newSet.remove(subKey);
                continue;
            }
            vertex.removeProperty(vertKey);
        }
        for (String item : newSet) {
            if (!(item instanceof String)) {
                throw new WindupException("Argument of " + method.getName() + " must be a Set<String>, but it contains: " + item.getClass());
            }
            vertex.setProperty(prefix + item, (Object)SET_VERTEX_PROP_VALUE);
        }
    }

    private void handleAdder(Vertex vertex, Method method, Object[] args, SetInProperties ann, FramedGraph<?> framedGraph) {
        if (args == null || args.length == 0) {
            throw new WindupException("Method must take at least one String argument: " + method.getName());
        }
        String prefix = this.preparePrefix(ann);
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (!(arg instanceof String)) {
                throw new WindupException("The arguments of the add*() method " + method.getName() + " must be String, but was: " + arg.getClass());
            }
            vertex.setProperty(prefix + arg, (Object)SET_VERTEX_PROP_VALUE);
        }
    }

    private void handleAddAll(Vertex vertex, Method method, Object[] args, SetInProperties ann, FramedGraph<?> framedGraph) {
        if (args == null || args.length != 1) {
            throw new WindupException("Method must take one String argument: " + method.getName());
        }
        String prefix = this.preparePrefix(ann);
        Set set = (Set)args[0];
        for (String item : set) {
            vertex.setProperty(prefix + item, (Object)SET_VERTEX_PROP_VALUE);
        }
    }

    private String preparePrefix(SetInProperties ann) {
        return "".equals(ann.propertyPrefix()) ? "" : ann.propertyPrefix() + ':';
    }
}

