/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.query;

import com.thinkaurelius.titan.core.attribute.Text;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.query.QueryGremlinCriterion;
import org.jboss.windup.config.query.QueryPropertyComparisonType;

class QueryPropertyCriterion
implements QueryGremlinCriterion {
    private String propertyName;
    private QueryPropertyComparisonType searchType;
    private Object searchValue;

    public QueryPropertyCriterion(String propertyName, QueryPropertyComparisonType searchType, Object searchValue) {
        this.propertyName = propertyName;
        this.searchType = searchType;
        this.searchValue = searchValue;
    }

    @Override
    public void query(GraphRewrite event, GremlinPipeline<Vertex, Vertex> pipeline) {
        switch (this.searchType) {
            case EQUALS: {
                pipeline.has(this.propertyName, this.searchValue);
                break;
            }
            case CONTAINS_TOKEN: {
                pipeline.has(this.propertyName, (Predicate)Text.CONTAINS, this.searchValue);
                break;
            }
            case CONTAINS_ANY_TOKEN: {
                pipeline.has(this.propertyName, (Predicate)new MultipleValueTitanPredicate(), this.searchValue);
                break;
            }
            case REGEX: {
                pipeline.has(this.propertyName, (Predicate)Text.REGEX, this.searchValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized query type: " + (Object)((Object)this.searchType));
            }
        }
    }

    public String toString() {
        return ".has(" + this.propertyName + "," + (Object)((Object)this.searchType) + "," + this.searchValue + ")";
    }

    private final class MultipleValueTitanPredicate
    implements TitanPredicate {
        private MultipleValueTitanPredicate() {
        }

        public boolean evaluate(Object first, Object second) {
            if (first == null) {
                return false;
            }
            if (second instanceof Iterable) {
                boolean found = false;
                for (Object element : (Iterable)second) {
                    if (element instanceof Enum && ((Enum)element).name().equals(first)) {
                        found = true;
                        break;
                    }
                    if (!first.equals(element)) continue;
                    found = true;
                    break;
                }
                return found;
            }
            return false;
        }

        public boolean isValidCondition(Object condition) {
            return condition != null && condition instanceof Iterable;
        }

        public boolean isValidValueType(Class<?> clazz) {
            return Iterable.class.isAssignableFrom(clazz);
        }

        public boolean hasNegation() {
            return false;
        }

        public TitanPredicate negate() {
            throw new UnsupportedOperationException();
        }

        public boolean isQNF() {
            return true;
        }
    }
}

