/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers.attribute;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.security.identity.Attribute;
import org.jboss.security.identity.AttributeFactory;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.MappingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAttributeMappingProvider
implements MappingProvider<List<Attribute<String>>> {
    private MappingResult<List<Attribute<String>>> result = new MappingResult();
    private Map<String, Object> options = new HashMap<String, Object>();

    @Override
    public void init(Map<String, Object> options) {
        this.options.putAll(options);
    }

    @Override
    public void performMapping(Map<String, Object> map, List<Attribute<String>> mappedObject) {
        ArrayList<Attribute<String>> attList = new ArrayList<Attribute<String>>();
        Principal principal = (Principal)map.get("Principal");
        if (principal != null) {
            String principalName = principal.getName();
            String emailAddress = (String)this.options.get(principalName + ".email");
            Attribute<String> att = AttributeFactory.createEmailAddress(emailAddress);
            attList.add(att);
        }
        mappedObject.addAll(attList);
        this.result.setMappedObject(mappedObject);
    }

    @Override
    public void setMappingResult(MappingResult<List<Attribute<String>>> result) {
        this.result = result;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return Attribute.class.isAssignableFrom(clazz);
    }
}

