/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.PrivateSubDeploymentMarker;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.TempFileProviderService;
import org.jboss.as.web.SharedTldsMetaDataBuilder;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.deployment.TldsMetaData;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;

public class WarStructureDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(WarStructureDeploymentProcessor.class);
    public static final String WEB_INF_LIB = "WEB-INF/lib";
    public static final String WEB_INF_CLASSES = "WEB-INF/classes";
    private static final ResourceRoot[] NO_ROOTS = new ResourceRoot[0];
    public static final VirtualFileFilter DEFAULT_WEB_INF_LIB_FILTER = new SuffixMatchFilter(".jar", VisitorAttributes.DEFAULT);
    private final WebMetaData sharedWebMetaData;
    private final SharedTldsMetaDataBuilder sharedTldsMetaData;

    public WarStructureDeploymentProcessor(WebMetaData sharedWebMetaData, SharedTldsMetaDataBuilder sharedTldsMetaData) {
        this.sharedWebMetaData = sharedWebMetaData;
        this.sharedTldsMetaData = sharedTldsMetaData;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        ResourceRoot deploymentResourceRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        VirtualFile deploymentRoot = deploymentResourceRoot.getRoot();
        if (deploymentRoot == null) {
            return;
        }
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        if (moduleSpecification == null) {
            return;
        }
        moduleSpecification.setPrivateModule(true);
        PrivateSubDeploymentMarker.mark((DeploymentUnit)deploymentUnit);
        deploymentResourceRoot.putAttachment(Attachments.INDEX_RESOURCE_ROOT, (Object)false);
        ModuleRootMarker.mark((ResourceRoot)deploymentResourceRoot, (boolean)false);
        MountHandle mountHandle = deploymentResourceRoot.getMountHandle();
        try {
            List<ResourceRoot> resourceRoots = this.createResourceRoots(deploymentRoot, mountHandle);
            for (ResourceRoot root : resourceRoots) {
                deploymentUnit.addToAttachmentList(Attachments.RESOURCE_ROOTS, (Object)root);
            }
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
        WarMetaData warMetaData = new WarMetaData();
        warMetaData.setSharedWebMetaData(this.sharedWebMetaData);
        deploymentUnit.putAttachment(WarMetaData.ATTACHMENT_KEY, (Object)warMetaData);
        TldsMetaData tldsMetaData = new TldsMetaData();
        tldsMetaData.setSharedTlds(this.sharedTldsMetaData);
        deploymentUnit.putAttachment(TldsMetaData.ATTACHMENT_KEY, (Object)tldsMetaData);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private List<ResourceRoot> createResourceRoots(VirtualFile deploymentRoot, MountHandle mountHandle) throws IOException, DeploymentUnitProcessingException {
        ArrayList<ResourceRoot> entries = new ArrayList<ResourceRoot>();
        ResourceRoot webInfClassesRoot = new ResourceRoot(deploymentRoot.getChild(WEB_INF_CLASSES).getName(), deploymentRoot.getChild(WEB_INF_CLASSES), null);
        ModuleRootMarker.mark((ResourceRoot)webInfClassesRoot);
        entries.add(webInfClassesRoot);
        this.createWebInfLibResources(deploymentRoot, entries);
        return entries;
    }

    void createWebInfLibResources(VirtualFile deploymentRoot, List<ResourceRoot> entries) throws IOException, DeploymentUnitProcessingException {
        VirtualFile webinfLib = deploymentRoot.getChild(WEB_INF_LIB);
        if (webinfLib.exists()) {
            List archives = webinfLib.getChildren(DEFAULT_WEB_INF_LIB_FILTER);
            for (VirtualFile archive : archives) {
                try {
                    Closeable closable = VFS.mountZip((VirtualFile)archive, (VirtualFile)archive, (TempFileProvider)TempFileProviderService.provider());
                    ResourceRoot webInfArchiveRoot = new ResourceRoot(archive.getName(), archive, new MountHandle(closable));
                    ModuleRootMarker.mark((ResourceRoot)webInfArchiveRoot);
                    entries.add(webInfArchiveRoot);
                }
                catch (IOException e) {
                    throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.failToProcessWebInfLib(archive), (Throwable)e);
                }
            }
        }
    }
}

