/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.session;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.Response;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.util.LifecycleSupport;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.session.ReplicationStatistics;
import org.jboss.as.web.session.SessionManager;
import org.jboss.as.web.session.SessionManagerMBean;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.SessionConfigMetaData;

public abstract class AbstractSessionManager
extends ManagerBase
implements SessionManager,
SessionManagerMBean,
Lifecycle {
    protected int maxActiveAllowed = -1;
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    protected volatile boolean started = false;
    private ReplicationStatistics stats = new ReplicationStatistics();
    protected AtomicInteger createdCounter = new AtomicInteger();
    protected AtomicInteger rejectedCounter = new AtomicInteger();
    protected AtomicInteger localActiveCounter = new AtomicInteger();
    protected AtomicInteger maxLocalActiveCounter = new AtomicInteger();
    protected AtomicInteger maxActiveCounter = new AtomicInteger();
    protected AtomicInteger expiredCounter = new AtomicInteger();
    protected long timeSinceLastReset = 0L;
    protected AtomicLong processingTime = new AtomicLong();
    protected AtomicInteger maxAliveTime = new AtomicInteger();
    protected AtomicInteger averageAliveTime = new AtomicInteger();
    protected AtomicInteger duplicates = new AtomicInteger();

    protected AbstractSessionManager(JBossWebMetaData metaData) {
        SessionConfigMetaData config;
        this.processExpiresFrequency = 1;
        Integer maxActiveSessions = metaData.getMaxActiveSessions();
        if (maxActiveSessions != null) {
            this.setMaxActiveAllowed(maxActiveSessions);
        }
        if ((config = metaData.getSessionConfig()) != null) {
            this.setMaxInactiveInterval(config.getSessionTimeout() * 60);
        }
    }

    public synchronized void start() throws LifecycleException {
        if (!this.initialized) {
            this.init();
        }
        this.log.debug((Object)"Starting JBossManager");
        if (this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.started = false;
        AbstractSessionManager abstractSessionManager = this;
        synchronized (abstractSessionManager) {
            this.resetStats();
            this.lifecycle.fireLifecycleEvent("stop", null);
            this.log.debug((Object)"Stopping JBossManager");
            this.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processExpires() {
        AbstractSessionManager abstractSessionManager = this;
        synchronized (abstractSessionManager) {
            if (this.started) {
                long start = System.currentTimeMillis();
                this.processExpirationPassivation();
                this.processingTime.addAndGet(System.currentTimeMillis() - start);
            }
        }
    }

    protected abstract void processExpirationPassivation();

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public int getRejectedSessions() {
        return this.rejectedCounter.get();
    }

    public void setRejectedSessions(int rejectedSessions) {
        this.rejectedCounter.set(rejectedSessions);
    }

    public void load() throws ClassNotFoundException, IOException {
        throw new UnsupportedOperationException(WebMessages.MESSAGES.noSessionPassivation());
    }

    public void unload() throws IOException {
        throw new UnsupportedOperationException(WebMessages.MESSAGES.noSessionPassivation());
    }

    @Override
    public void setNewSessionCookie(String sessionId, HttpServletResponse response) {
        if (response != null) {
            Context context = (Context)this.container;
            Connector connector = ((Response)response).getConnector();
            if (context.getCookies()) {
                Cookie cookie = new Cookie(Globals.SESSION_COOKIE_NAME, sessionId);
                cookie.setMaxAge(-1);
                if (context.getSessionCookie().getPath() != null) {
                    cookie.setPath(context.getSessionCookie().getPath());
                } else {
                    String contextPath = context.getEncodedPath();
                    if ("".equals(contextPath)) {
                        contextPath = "/";
                    }
                    cookie.setPath(contextPath);
                }
                if (context.getSessionCookie().getComment() != null) {
                    cookie.setComment(context.getSessionCookie().getComment());
                }
                if (context.getSessionCookie().getDomain() != null) {
                    cookie.setDomain(context.getSessionCookie().getDomain());
                }
                if (context.getSessionCookie().isHttpOnly()) {
                    cookie.setHttpOnly(true);
                }
                if (context.getSessionCookie().isSecure()) {
                    cookie.setSecure(true);
                }
                if (connector.getSecure()) {
                    cookie.setSecure(true);
                }
                this.log.tracef("Setting cookie with session id: %s & name: %s", (Object)sessionId, (Object)Globals.SESSION_COOKIE_NAME);
                response.addCookie(cookie);
            }
        }
    }

    @Override
    public ReplicationStatistics getReplicationStatistics() {
        return this.stats;
    }

    @Override
    public void resetStats() {
        this.stats.resetStats();
        this.maxActiveCounter.set(this.localActiveCounter.get());
        this.rejectedCounter.set(0);
        this.createdCounter.set(0);
        this.expiredCounter.set(0);
        this.processingTime.set(0L);
        this.maxAliveTime.set(0);
        this.averageAliveTime.set(0);
        this.duplicates.set(0);
        this.timeSinceLastReset = System.currentTimeMillis();
    }

    @Override
    public long getTimeSinceLastReset() {
        return this.timeSinceLastReset;
    }

    @Override
    public long getActiveSessionCount() {
        return this.calcActiveSessions();
    }

    @Override
    public long getLocalActiveSessionCount() {
        return this.localActiveCounter.get();
    }

    @Override
    public long getRejectedSessionCount() {
        return this.rejectedCounter.get();
    }

    @Override
    public long getCreatedSessionCount() {
        return this.createdCounter.get();
    }

    @Override
    public long getExpiredSessionCount() {
        return this.expiredCounter.get();
    }

    @Override
    public long getMaxActiveSessionCount() {
        return this.maxActiveCounter.get();
    }

    @Override
    public long getMaxLocalActiveSessionCount() {
        return this.maxLocalActiveCounter.get();
    }

    @Override
    public int getMaxActiveAllowed() {
        return this.maxActiveAllowed;
    }

    @Override
    public void setMaxActiveAllowed(int max) {
        this.maxActiveAllowed = max;
    }

    @Override
    public int getMaxActiveSessions() {
        return this.maxActive;
    }

    @Override
    public Map.Entry<String, String> parse(String sessionId) {
        String realId = sessionId;
        String jvmRoute = null;
        int index = sessionId.indexOf(46, 0);
        if (index > 0) {
            realId = sessionId.substring(0, index);
            if (index < sessionId.length() - 1) {
                jvmRoute = sessionId.substring(index + 1);
            }
        }
        return new AbstractMap.SimpleImmutableEntry<String, Object>(realId, jvmRoute);
    }

    @Override
    public String createSessionId(String realId, String jvmRoute) {
        return jvmRoute != null ? realId + "." + jvmRoute : realId;
    }

    protected void sessionExpired(int sessionAliveTime) {
        int expCount;
        int newAverage;
        int current = this.maxAliveTime.get();
        while (sessionAliveTime > current && !this.maxAliveTime.compareAndSet(current, sessionAliveTime)) {
            current = this.maxAliveTime.get();
        }
        this.expiredCounter.incrementAndGet();
        do {
            expCount = this.expiredCounter.get();
        } while (!this.averageAliveTime.compareAndSet(current = this.averageAliveTime.get(), newAverage = (current * (expCount - 1) + sessionAliveTime) / expCount));
    }

    protected int calcActiveSessions() {
        this.localActiveCounter.set(this.sessions.size());
        int active = this.localActiveCounter.get();
        int maxLocal = this.maxLocalActiveCounter.get();
        while (active > maxLocal) {
            if (this.maxLocalActiveCounter.compareAndSet(maxLocal, active)) continue;
            maxLocal = this.maxLocalActiveCounter.get();
        }
        int count = this.getTotalActiveSessions();
        int max = this.maxActiveCounter.get();
        while (count > max) {
            if (this.maxActiveCounter.compareAndSet(max, count)) continue;
            max = this.maxActiveCounter.get();
            count = this.getTotalActiveSessions();
        }
        return count;
    }

    protected abstract int getTotalActiveSessions();
}

