/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.ui;

import com.sun.faces.facelets.el.VariableMapperWrapper;
import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.VariableMapper;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;

public final class IncludeHandler
extends TagHandlerImpl {
    private static final Logger log = FacesLogger.FACELETS_INCLUDE.getLogger();
    private final TagAttribute src;
    private static final String IS_IN_INCLUDE_KEY = IncludeHandler.class.getPackage().getName() + ".IS_IN_INCLUDE";

    public IncludeHandler(TagConfig config) {
        super(config);
        TagAttribute attr = null;
        attr = this.getAttribute("src");
        if (null == attr) {
            attr = this.getAttribute("file");
        }
        if (null == attr) {
            attr = this.getAttribute("page");
        }
        if (null == attr) {
            throw new TagException(this.tag, "Attribute 'src', 'file' or 'page' is required");
        }
        this.src = attr;
    }

    public static boolean isInInclude() {
        FaceletContext faceletContext = (FaceletContext)FacesContext.getCurrentInstance().getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
        boolean isInInclude = null != faceletContext && null != faceletContext.getAttribute(IS_IN_INCLUDE_KEY);
        return isInInclude;
    }

    private void setIsInInclude(FaceletContext ctx, boolean newValue) {
        ctx.setAttribute(IS_IN_INCLUDE_KEY, (Object)newValue);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        String path = this.src.getValue(ctx);
        if (path == null || path.length() == 0) {
            return;
        }
        VariableMapper orig = ctx.getVariableMapper();
        ctx.setVariableMapper((VariableMapper)new VariableMapperWrapper(orig));
        try {
            this.nextHandler.apply(ctx, null);
            this.setIsInInclude(ctx, true);
            ctx.includeFacelet(parent, path);
        }
        catch (IOException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, e.toString(), e);
            }
            throw new TagAttributeException(this.tag, this.src, "Invalid path : " + path);
        }
        finally {
            ctx.setVariableMapper(orig);
            this.setIsInInclude(ctx, false);
        }
    }
}

