/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec.configuration.options;

import java.io.File;
import org.jboss.windup.config.AbstractPathConfigurationOption;
import org.jboss.windup.config.InputType;
import org.jboss.windup.config.ValidationResult;

public class InputPathOption
extends AbstractPathConfigurationOption {
    public static final String NAME = "input";
    private static long SIZE_WARNING_TRESHOLD_MB = 10L;

    public InputPathOption() {
        super(true);
    }

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return "Input path";
    }

    public String getDescription() {
        return "Input file or directory (a directory is required for source mode)";
    }

    public ValidationResult validate(Object fileObject) {
        ValidationResult result = super.validate(fileObject);
        if (!result.isSuccess()) {
            return result;
        }
        File file = (File)fileObject;
        if (!file.exists()) {
            return new ValidationResult(ValidationResult.Level.ERROR, "Input path not found: " + file.getAbsolutePath());
        }
        if (file.isFile() && file.length() > SIZE_WARNING_TRESHOLD_MB * 1024L * 1024L) {
            return new ValidationResult(ValidationResult.Level.PROMPT_TO_CONTINUE, "The input application is large. Processing may take a very long time. Please consult the Windup User Guide for performance tips. Would you like to continue?", true);
        }
        return ValidationResult.SUCCESS;
    }

    public InputType getUIType() {
        return InputType.FILE_OR_DIRECTORY;
    }

    public boolean isRequired() {
        return true;
    }

    public int getPriority() {
        return 10000;
    }
}

