/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.DependencyRepository;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.dependencies.util.Dependencies;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.maven.plugins.MavenPlugin;
import org.jboss.forge.addon.maven.plugins.MavenPluginAdapter;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.maven.projects.MavenPluginFacet;
import org.jboss.forge.addon.maven.projects.facets.exceptions.PluginNotFoundException;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.furnace.util.Strings;

public class MavenPluginFacetImpl
extends AbstractFacet<Project>
implements MavenPluginFacet {
    private static final String DEFAULT_GROUPID = "org.apache.maven.plugins";

    public boolean install() {
        return true;
    }

    public boolean isInstalled() {
        return ((Project)this.getFaceted()).hasFacet(MavenFacet.class);
    }

    public List<MavenPlugin> listConfiguredPlugins() {
        return this.listConfiguredPlugins(false, false, null);
    }

    public List<MavenPlugin> listConfiguredPlugins(org.jboss.forge.addon.maven.profiles.Profile profile) {
        return this.listConfiguredPlugins(false, false, profile);
    }

    public List<MavenPlugin> listConfiguredEffectivePlugins() {
        return this.listConfiguredPlugins(false, true, null);
    }

    public List<MavenPlugin> listConfiguredEffectivePlugins(org.jboss.forge.addon.maven.profiles.Profile profile) {
        return this.listConfiguredPlugins(false, true, profile);
    }

    public List<MavenPlugin> listConfiguredManagedPlugins() {
        return this.listConfiguredPlugins(true, false, null);
    }

    public List<MavenPlugin> listConfiguredManagedPlugins(org.jboss.forge.addon.maven.profiles.Profile profile) {
        return this.listConfiguredPlugins(true, false, profile);
    }

    public List<MavenPlugin> listConfiguredEffectiveManagedPlugins() {
        return this.listConfiguredPlugins(true, true, null);
    }

    public List<MavenPlugin> listConfiguredEffectiveManagedPlugins(org.jboss.forge.addon.maven.profiles.Profile profile) {
        return this.listConfiguredPlugins(true, true, profile);
    }

    public void addPlugin(MavenPlugin plugin) {
        this.addPlugin(plugin, false, null);
    }

    public void addPlugin(MavenPlugin plugin, org.jboss.forge.addon.maven.profiles.Profile profile) {
        this.addPlugin(plugin, false, profile);
    }

    public void addManagedPlugin(MavenPlugin plugin) {
        this.addPlugin(plugin, true, null);
    }

    public void addManagedPlugin(MavenPlugin plugin, org.jboss.forge.addon.maven.profiles.Profile profile) {
        this.addPlugin(plugin, true, profile);
    }

    public MavenPlugin getPlugin(Coordinate coordinate) {
        return this.getPlugin(coordinate, false, false, null);
    }

    public MavenPlugin getPlugin(Coordinate coordinate, org.jboss.forge.addon.maven.profiles.Profile profile) {
        return this.getPlugin(coordinate, false, false, profile);
    }

    public MavenPlugin getEffectivePlugin(Coordinate dependency) {
        return this.getPlugin(dependency, false, true, null);
    }

    public MavenPlugin getEffectivePlugin(Coordinate coordinate, org.jboss.forge.addon.maven.profiles.Profile profile) {
        return this.getPlugin(coordinate, false, true, profile);
    }

    public MavenPlugin getManagedPlugin(Coordinate dependency) {
        return this.getPlugin(dependency, true, false, null);
    }

    public MavenPlugin getManagedPlugin(Coordinate coordinate, org.jboss.forge.addon.maven.profiles.Profile profile) {
        return this.getPlugin(coordinate, true, false, profile);
    }

    public MavenPlugin getEffectiveManagedPlugin(Coordinate dependency) {
        return this.getPlugin(dependency, true, true, null);
    }

    public MavenPlugin getEffectiveManagedPlugin(Coordinate coordinate, org.jboss.forge.addon.maven.profiles.Profile profile) {
        return this.getPlugin(coordinate, true, true, profile);
    }

    public boolean hasPlugin(Coordinate dependency) {
        return this.hasPlugin(dependency, false, false, null);
    }

    public boolean hasPlugin(Coordinate coordinate, org.jboss.forge.addon.maven.profiles.Profile profile) {
        return this.hasPlugin(coordinate, false, false, profile);
    }

    public boolean hasEffectivePlugin(Coordinate dependency) {
        return this.hasPlugin(dependency, false, true, null);
    }

    public boolean hasEffectivePlugin(Coordinate coordinate, org.jboss.forge.addon.maven.profiles.Profile profile) {
        return this.hasPlugin(coordinate, false, true, profile);
    }

    public boolean hasManagedPlugin(Coordinate dependency) {
        return this.hasPlugin(dependency, true, false, null);
    }

    public boolean hasManagedPlugin(Coordinate coordinate, org.jboss.forge.addon.maven.profiles.Profile profile) {
        return this.hasPlugin(coordinate, true, false, profile);
    }

    public boolean hasEffectiveManagedPlugin(Coordinate managedDependency) {
        return this.hasPlugin(managedDependency, true, true, null);
    }

    public boolean hasEffectiveManagedPlugin(Coordinate coordinate, org.jboss.forge.addon.maven.profiles.Profile profile) {
        return this.hasPlugin(coordinate, true, true, profile);
    }

    public void removePlugin(Coordinate dependency) {
        this.removePlugin(dependency, false, null);
    }

    public void removePlugin(Coordinate coordinate, org.jboss.forge.addon.maven.profiles.Profile profile) {
        this.removePlugin(coordinate, false, profile);
    }

    public void removeManagedPlugin(Coordinate dependency) {
        this.removePlugin(dependency, true, null);
    }

    public void removeManagedPlugin(Coordinate coordinate, org.jboss.forge.addon.maven.profiles.Profile profileParam) {
        this.removePlugin(coordinate, true, profileParam);
    }

    public void updatePlugin(MavenPlugin plugin) {
        this.updatePlugin(plugin, false, null);
    }

    public void updatePlugin(MavenPlugin plugin, org.jboss.forge.addon.maven.profiles.Profile profile) {
        this.updatePlugin(plugin, false, profile);
    }

    public void updateManagedPlugin(MavenPlugin plugin) {
        this.updatePlugin(plugin, true, null);
    }

    public void updateManagedPlugin(MavenPlugin plugin, org.jboss.forge.addon.maven.profiles.Profile profile) {
        this.updatePlugin(plugin, true, profile);
    }

    public void addPluginRepository(String id, String url) {
        if (!this.hasPluginRepository(url)) {
            MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
            Model pom = maven.getModel();
            Repository repo = new Repository();
            repo.setId(id);
            repo.setUrl(url);
            pom.getPluginRepositories().add(repo);
            maven.setModel(pom);
        }
    }

    public void addPluginRepository(String id, String url, org.jboss.forge.addon.maven.profiles.Profile profileParam) {
        if (profileParam == null) {
            this.addPluginRepository(id, url);
        } else if (!this.hasPluginRepository(url, profileParam)) {
            MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
            Model pom = maven.getModel();
            Profile profile = this.getProfile(pom, profileParam);
            if (profile == null) {
                profile = profileParam.getAsMavenProfile();
                pom.getProfiles().add(profile);
            }
            Repository repo = new Repository();
            repo.setId(id);
            repo.setUrl(url);
            profile.addPluginRepository(repo);
            maven.setModel(pom);
        }
    }

    public boolean hasPluginRepository(String url) {
        if (url != null) {
            String trimmedUrl = url.trim();
            MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
            Model pom = maven.getModel();
            for (Repository repo : pom.getPluginRepositories()) {
                if (!repo.getUrl().trim().equals(trimmedUrl)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPluginRepository(String url, org.jboss.forge.addon.maven.profiles.Profile profileParam) {
        if (profileParam == null) {
            return this.hasPluginRepository(url);
        }
        if (url != null) {
            String trimmedUrl = url.trim();
            MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
            Model pom = maven.getModel();
            Profile profile = this.getProfile(pom, profileParam);
            if (profile != null) {
                for (Repository repo : profile.getPluginRepositories()) {
                    if (!repo.getUrl().trim().equals(trimmedUrl)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public DependencyRepository removePluginRepository(String url) {
        if (url != null) {
            MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
            Model pom = maven.getModel();
            List repos = pom.getPluginRepositories();
            for (Repository repo : repos) {
                if (!repo.getUrl().equals(url.trim())) continue;
                repos.remove(repo);
                maven.setModel(pom);
                return new DependencyRepository(repo.getId(), repo.getUrl());
            }
        }
        return null;
    }

    public DependencyRepository removePluginRepository(String url, org.jboss.forge.addon.maven.profiles.Profile profileParam) {
        if (profileParam == null) {
            return this.removePluginRepository(url);
        }
        if (url != null) {
            String trimmedUrl = url.trim();
            MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
            Model pom = maven.getModel();
            Profile profile = this.getProfile(pom, profileParam);
            if (profile != null) {
                List repos = profile.getPluginRepositories();
                for (Repository repo : repos) {
                    if (!repo.getUrl().equals(trimmedUrl)) continue;
                    repos.remove(repo);
                    maven.setModel(pom);
                    return new DependencyRepository(repo.getId(), repo.getUrl());
                }
            }
        }
        return null;
    }

    public List<DependencyRepository> getPluginRepositories() {
        ArrayList<DependencyRepository> results = new ArrayList<DependencyRepository>();
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        List repos = pom.getPluginRepositories();
        if (repos != null) {
            for (Repository repo : repos) {
                results.add(new DependencyRepository(repo.getId(), repo.getUrl()));
            }
        }
        return Collections.unmodifiableList(results);
    }

    public List<DependencyRepository> getPluginRepositories(org.jboss.forge.addon.maven.profiles.Profile profileParam) {
        if (profileParam == null) {
            return this.getPluginRepositories();
        }
        ArrayList<DependencyRepository> results = new ArrayList<DependencyRepository>();
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        Profile profile = this.getProfile(pom, profileParam);
        if (profile != null) {
            for (Repository repo : profile.getPluginRepositories()) {
                results.add(new DependencyRepository(repo.getId(), repo.getUrl()));
            }
        }
        return Collections.unmodifiableList(results);
    }

    public MavenPlugin merge(MavenPlugin dominant, MavenPlugin recessive) {
        MavenPluginAdapter merged = new MavenPluginAdapter(dominant);
        if (Dependencies.areEquivalent((Coordinate)dominant.getCoordinate(), (Coordinate)recessive.getCoordinate())) {
            MavenPluginAdapter recessiveAdaptater = new MavenPluginAdapter(recessive);
            Xpp3Dom mergedDomConfig = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)((Xpp3Dom)merged.getConfiguration()), (Xpp3Dom)((Xpp3Dom)recessiveAdaptater.getConfiguration()));
            merged.setConfiguration((Object)mergedDomConfig);
            List<PluginExecution> mergedExecutions = this.mergePluginsExecutions(merged.getExecutionsAsMap(), recessiveAdaptater.getExecutionsAsMap());
            merged.setExecutions(mergedExecutions);
            if (Strings.isNullOrEmpty((String)merged.getVersion())) {
                merged.setVersion(recessiveAdaptater.getVersion());
            }
            if (Strings.isNullOrEmpty((String)merged.getExtensions())) {
                merged.setExtensions(recessiveAdaptater.getExtensions());
            }
            if (Strings.isNullOrEmpty((String)merged.getInherited())) {
                merged.setExtensions(recessiveAdaptater.getInherited());
            }
        }
        return merged;
    }

    private List<PluginExecution> mergePluginsExecutions(Map<String, PluginExecution> dominant, Map<String, PluginExecution> recessive) {
        PluginExecution mergedPluginExecution;
        PluginExecution pluginExecution;
        ArrayList<PluginExecution> executions = new ArrayList<PluginExecution>();
        for (Map.Entry<String, PluginExecution> entry : dominant.entrySet()) {
            pluginExecution = entry.getValue();
            mergedPluginExecution = new PluginExecution();
            mergedPluginExecution.setId(pluginExecution.getId());
            if (Strings.isNullOrEmpty((String)pluginExecution.getPhase()) && recessive.containsKey(entry.getKey())) {
                mergedPluginExecution.setPhase(recessive.get(entry.getKey()).getPhase());
            } else {
                mergedPluginExecution.setPhase(pluginExecution.getPhase());
            }
            HashMap<String, Boolean> hasGoals = new HashMap<String, Boolean>();
            for (String goal : pluginExecution.getGoals()) {
                mergedPluginExecution.addGoal(goal);
                hasGoals.put(goal, new Boolean(true));
            }
            if (recessive.containsKey(entry.getKey())) {
                for (String goal : recessive.get(entry.getKey()).getGoals()) {
                    if (hasGoals.containsKey(goal)) continue;
                    mergedPluginExecution.addGoal(goal);
                }
            }
            if (pluginExecution.getConfiguration() != null) {
                if (recessive.containsKey(entry.getKey()) && recessive.get(entry.getKey()).getConfiguration() != null) {
                    Xpp3Dom mergedDomConfig = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)((Xpp3Dom)pluginExecution.getConfiguration()), (Xpp3Dom)((Xpp3Dom)recessive.get(entry.getKey()).getConfiguration()));
                    mergedPluginExecution.setConfiguration((Object)mergedDomConfig);
                } else {
                    mergedPluginExecution.setConfiguration(pluginExecution.getConfiguration());
                }
            }
            executions.add(mergedPluginExecution);
        }
        for (Map.Entry<String, PluginExecution> entry : recessive.entrySet()) {
            if (dominant.containsKey(entry.getKey())) continue;
            pluginExecution = entry.getValue();
            mergedPluginExecution = new PluginExecution();
            mergedPluginExecution.setId(pluginExecution.getId());
            mergedPluginExecution.setPhase(pluginExecution.getPhase());
            for (String goal : pluginExecution.getGoals()) {
                mergedPluginExecution.addGoal(goal);
            }
            if (pluginExecution.getConfiguration() != null) {
                mergedPluginExecution.setConfiguration(pluginExecution.getConfiguration());
            }
            executions.add(mergedPluginExecution);
        }
        return executions;
    }

    private List<Plugin> getPluginsPOM(boolean managedPlugin, boolean effectivePlugin, org.jboss.forge.addon.maven.profiles.Profile profileParam) {
        MavenFacet mavenCoreFacet = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        BuildBase build = this.getBuild(mavenCoreFacet.getModel(), profileParam);
        if (build != null) {
            if (managedPlugin) {
                PluginManagement pluginManagement = build.getPluginManagement();
                if (pluginManagement != null) {
                    return pluginManagement.getPlugins();
                }
            } else {
                return build.getPlugins();
            }
        }
        return Collections.emptyList();
    }

    private List<MavenPlugin> listConfiguredPlugins(boolean managedPlugin, boolean effectivePlugin, org.jboss.forge.addon.maven.profiles.Profile profileParam) {
        ArrayList<MavenPlugin> plugins = new ArrayList<MavenPlugin>();
        for (Plugin plugin : this.getPluginsPOM(managedPlugin, effectivePlugin, profileParam)) {
            plugins.add((MavenPlugin)new MavenPluginAdapter(plugin));
        }
        return plugins;
    }

    private void addPlugin(MavenPlugin plugin, boolean managedPlugin, org.jboss.forge.addon.maven.profiles.Profile profileParam) {
        MavenFacet mavenCoreFacet = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = mavenCoreFacet.getModel();
        BuildBase build = this.getBuild(pom, profileParam);
        if (managedPlugin) {
            PluginManagement pluginManagement = build.getPluginManagement();
            if (pluginManagement == null) {
                pluginManagement = new PluginManagement();
                build.setPluginManagement(pluginManagement);
            }
            pluginManagement.addPlugin((Plugin)new MavenPluginAdapter(plugin));
        } else {
            build.addPlugin((Plugin)new MavenPluginAdapter(plugin));
        }
        mavenCoreFacet.setModel(pom);
    }

    private BuildBase getBuild(Model pom, org.jboss.forge.addon.maven.profiles.Profile profileParam) {
        Build build;
        if (profileParam == null) {
            build = pom.getBuild();
            if (build == null) {
                pom.setBuild(new Build());
                build = pom.getBuild();
            }
        } else {
            Profile profile = this.getProfile(pom, profileParam);
            if (profile == null) {
                profile = profileParam.getAsMavenProfile();
                profile.setBuild((BuildBase)new Build());
                pom.getProfiles().add(profile);
            }
            if ((build = profile.getBuild()) == null) {
                profile.setBuild((BuildBase)new Build());
                build = profile.getBuild();
            }
        }
        return build;
    }

    private MavenPlugin getPlugin(Coordinate dependency, boolean managedPlugin, boolean effectivePlugin, org.jboss.forge.addon.maven.profiles.Profile profileParam) {
        String groupId = dependency.getGroupId();
        groupId = groupId == null || groupId.equals("") ? DEFAULT_GROUPID : groupId;
        for (MavenPlugin mavenPlugin : this.listConfiguredPlugins(managedPlugin, effectivePlugin, profileParam)) {
            Coordinate temp = mavenPlugin.getCoordinate();
            if (!Dependencies.areEquivalent((Coordinate)temp, (Coordinate)CoordinateBuilder.create((Coordinate)dependency).setGroupId(groupId))) continue;
            return mavenPlugin;
        }
        throw new PluginNotFoundException(groupId, dependency.getArtifactId());
    }

    private Profile getProfile(Model model, org.jboss.forge.addon.maven.profiles.Profile profileParam) {
        Profile result = null;
        if (profileParam != null) {
            for (Profile profile : model.getProfiles()) {
                if (!profileParam.getId().equals(profile.getId())) continue;
                result = profile;
                break;
            }
        }
        return result;
    }

    private boolean hasPlugin(Coordinate dependency, boolean managedPlugin, boolean effectivePlugin, org.jboss.forge.addon.maven.profiles.Profile profileParam) {
        try {
            this.getPlugin(dependency, managedPlugin, effectivePlugin, profileParam);
            return true;
        }
        catch (PluginNotFoundException ex) {
            return false;
        }
    }

    private void removePlugin(Coordinate dependency, boolean managedPlugin, org.jboss.forge.addon.maven.profiles.Profile profileParam) {
        MavenPlugin pluginToRemove = null;
        if (managedPlugin && this.hasManagedPlugin(dependency, profileParam)) {
            pluginToRemove = this.getManagedPlugin(dependency, profileParam);
        } else if (this.hasPlugin(dependency)) {
            pluginToRemove = this.getPlugin(dependency, profileParam);
        }
        if (pluginToRemove != null) {
            MavenFacet mavenCoreFacet = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
            Model pom = mavenCoreFacet.getModel();
            BuildBase build = this.getBuild(pom, profileParam);
            if (managedPlugin) {
                PluginManagement pluginManagement = build.getPluginManagement();
                pluginManagement.removePlugin((Plugin)new MavenPluginAdapter(pluginToRemove));
            } else {
                build.removePlugin((Plugin)new MavenPluginAdapter(pluginToRemove));
            }
            mavenCoreFacet.setModel(pom);
        }
    }

    private void updatePlugin(MavenPlugin plugin, boolean managedPlugin, org.jboss.forge.addon.maven.profiles.Profile profileParam) {
        this.removePlugin(plugin.getCoordinate(), managedPlugin, profileParam);
        if (!this.hasPlugin(plugin.getCoordinate(), managedPlugin, false, profileParam)) {
            this.addPlugin(plugin, managedPlugin, profileParam);
        }
    }
}

