/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects.archetype.ui;

import java.net.URL;
import org.jboss.forge.addon.maven.projects.archetype.ui.AbstractArchetypeCommand;
import org.jboss.forge.addon.resource.URLResource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class ArchetypeAddCommand
extends AbstractArchetypeCommand {
    private UIInput<String> named;
    private UIInput<URLResource> url;

    public void initializeUI(UIBuilder builder) throws Exception {
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.named = (UIInput)((UIInput)((UIInput)factory.createInput("named", String.class).setLabel("Archetype catalog Name")).setDescription("The archetype catalog name to be used")).setRequired(true);
        this.url = (UIInput)((UIInput)((UIInput)factory.createInput("url", URLResource.class).setLabel("Archetype catalog URL")).setDescription("The archetype catalog URL to be used")).setRequired(true);
        builder.add(this.named).add(this.url);
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Archetype: Add").category(Categories.create((String[])new String[]{"Maven"})).description("Adds an archetype catalog to the Forge configuration file");
    }

    public Result execute(UIExecutionContext context) throws Exception {
        this.getConfiguration().setProperty((String)this.named.getValue(), (Object)((URLResource)this.url.getValue()).getFullyQualifiedName());
        this.getArchetypeCatalogFactoryRegistry().addArchetypeCatalogFactory((String)this.named.getValue(), (URL)((URLResource)this.url.getValue()).getUnderlyingResourceObject());
        return Results.success();
    }
}

