/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects.javaee;

import java.util.List;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.DependencyQuery;
import org.jboss.forge.addon.dependencies.DependencyRepository;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.dependencies.builder.DependencyQueryBuilder;
import org.jboss.forge.addon.dependencies.util.NonSnapshotDependencyFilter;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.facets.constraints.FacetConstraints;
import org.jboss.forge.addon.javaee.jpa.JPAFacet;
import org.jboss.forge.addon.javaee.jpa.MetaModelProvider;
import org.jboss.forge.addon.javaee.jpa.PersistenceMetaModelFacet;
import org.jboss.forge.addon.javaee.jpa.PersistenceProvider;
import org.jboss.forge.addon.maven.plugins.Configuration;
import org.jboss.forge.addon.maven.plugins.ConfigurationBuilder;
import org.jboss.forge.addon.maven.plugins.ConfigurationElement;
import org.jboss.forge.addon.maven.plugins.ConfigurationElementBuilder;
import org.jboss.forge.addon.maven.plugins.Execution;
import org.jboss.forge.addon.maven.plugins.ExecutionBuilder;
import org.jboss.forge.addon.maven.plugins.MavenPlugin;
import org.jboss.forge.addon.maven.plugins.MavenPluginAdapter;
import org.jboss.forge.addon.maven.plugins.MavenPluginBuilder;
import org.jboss.forge.addon.maven.projects.MavenPluginFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.shrinkwrap.descriptor.api.persistence.PersistenceCommonDescriptor;
import org.jboss.shrinkwrap.descriptor.api.persistence.PersistenceUnitCommon;

@FacetConstraints(value={@FacetConstraint(value={JPAFacet.class}), @FacetConstraint(value={MavenPluginFacet.class})})
public class MavenPersistenceMetaModelFacet
extends AbstractFacet<Project>
implements PersistenceMetaModelFacet {
    private MetaModelProvider metaModelProvider;

    public boolean install() {
        MetaModelProvider provider = this.getMetaModelProvider();
        this.addProcessorPlugin(provider);
        this.modifyCompilerPlugin();
        this.addPluginRepository(provider);
        return true;
    }

    public void setMetaModelProvider(MetaModelProvider provider) {
        this.metaModelProvider = provider;
    }

    public boolean isInstalled() {
        return this.processorConfigured(this.getMetaModelProvider());
    }

    public MetaModelProvider getMetaModelProvider() {
        if (this.metaModelProvider == null) {
            this.metaModelProvider = this.lookupProvider();
        }
        return this.metaModelProvider;
    }

    public String getProcessor() {
        return this.getMetaModelProvider().getProcessor();
    }

    public String getCompilerArgs() {
        return this.getMetaModelProvider().getCompilerArguments();
    }

    public Coordinate getProcessorCoordinate() {
        return this.getMetaModelProvider().getAptCoordinate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaModelProvider lookupProvider() {
        PersistenceCommonDescriptor config = (PersistenceCommonDescriptor)((JPAFacet)((Project)this.getFaceted()).getFacet(JPAFacet.class)).getConfig();
        List allPersistenceUnit = config.getAllPersistenceUnit();
        String providerName = allPersistenceUnit.size() > 0 ? ((PersistenceUnitCommon)allPersistenceUnit.get(0)).getProvider() : null;
        Imported services = SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), PersistenceProvider.class);
        for (PersistenceProvider candidate : services) {
            try {
                if (!Strings.compare((String)candidate.getProvider(), (String)providerName)) continue;
                MetaModelProvider metaModelProvider = candidate.getMetaModelProvider();
                return metaModelProvider;
            }
            finally {
                services.release((Object)candidate);
            }
        }
        return ((PersistenceProvider)services.get()).getMetaModelProvider();
    }

    private void addProcessorPlugin(MetaModelProvider provider) {
        CoordinateBuilder processorDependency;
        MavenPluginFacet facet = (MavenPluginFacet)((Project)this.getFaceted()).getFacet(MavenPluginFacet.class);
        if (facet.hasPlugin((Coordinate)(processorDependency = this.createProcessorCoordinate()))) {
            return;
        }
        Coordinate versioned = this.getLatestVersion((Coordinate)processorDependency);
        ConfigurationBuilder configuration = ConfigurationBuilder.create();
        configuration.createConfigurationElement("processors").addChild("processor").setText(provider.getProcessor());
        if (!Strings.isNullOrEmpty((String)provider.getCompilerArguments())) {
            configuration.createConfigurationElement("compilerArguments").setText(provider.getCompilerArguments());
        }
        ExecutionBuilder execution = ExecutionBuilder.create().setId("process").setPhase("generate-sources").addGoal("process").setConfig((Configuration)configuration);
        Coordinate aptDependency = provider.getAptCoordinate();
        if (Strings.isNullOrEmpty((String)aptDependency.getVersion())) {
            aptDependency = this.getLatestVersion(aptDependency);
        }
        MavenPluginBuilder processorPlugin = MavenPluginBuilder.create().setCoordinate(versioned).addExecution((Execution)execution).addPluginDependency((Dependency)DependencyBuilder.create().setCoordinate(aptDependency));
        facet.addPlugin((MavenPlugin)processorPlugin);
        ((DependencyFacet)((Project)this.getFaceted()).getFacet(DependencyFacet.class)).addDirectDependency((Dependency)DependencyBuilder.create().setCoordinate(aptDependency).setScopeType("provided"));
    }

    private CoordinateBuilder createProcessorCoordinate() {
        return CoordinateBuilder.create().setGroupId("org.bsc.maven").setArtifactId("maven-processor-plugin");
    }

    private void modifyCompilerPlugin() {
        CoordinateBuilder compilerDependency = CoordinateBuilder.create().setGroupId("org.apache.maven.plugins").setArtifactId("maven-compiler-plugin");
        MavenPluginFacet pluginFacet = (MavenPluginFacet)((Project)this.getFaceted()).getFacet(MavenPluginFacet.class);
        MavenPluginAdapter compiler = pluginFacet.hasPlugin((Coordinate)compilerDependency) ? new MavenPluginAdapter(pluginFacet.getPlugin((Coordinate)compilerDependency)) : new MavenPluginAdapter((MavenPlugin)MavenPluginBuilder.create().setCoordinate((Coordinate)compilerDependency));
        Configuration config = compiler.getConfig();
        if (!config.hasConfigurationElement("proc")) {
            ConfigurationElementBuilder proc = ConfigurationBuilder.create().createConfigurationElement("proc").setText("none");
            config.addConfigurationElement((ConfigurationElement)proc);
            compiler.setConfig(config);
        }
        pluginFacet.updatePlugin((MavenPlugin)compiler);
    }

    private boolean processorConfigured(MetaModelProvider provider) {
        Configuration config;
        MavenPlugin plugin;
        CoordinateBuilder dependency = this.createProcessorCoordinate().setVersion(null);
        MavenPluginFacet pluginFacet = (MavenPluginFacet)((Project)this.getFaceted()).getFacet(MavenPluginFacet.class);
        if (pluginFacet.hasPlugin((Coordinate)dependency) && (plugin = pluginFacet.getPlugin((Coordinate)dependency)).listExecutions().size() > 0 && (config = ((Execution)plugin.listExecutions().get(0)).getConfig()).hasConfigurationElement("processors")) {
            ConfigurationElement element = config.getConfigurationElement("processors").getChildByName("processor");
            return element.getText().equals(provider.getProcessor());
        }
        return false;
    }

    private void addPluginRepository(MetaModelProvider provider) {
        DependencyRepository repository = provider.getAptPluginRepository();
        if (repository != null) {
            MavenPluginFacet pluginFacet = (MavenPluginFacet)((Project)this.getFaceted()).getFacet(MavenPluginFacet.class);
            pluginFacet.addPluginRepository(repository.getId(), repository.getUrl());
        }
    }

    private Coordinate getLatestVersion(Coordinate dependency) {
        DependencyFacet dependencyFacet = (DependencyFacet)((Project)this.getFaceted()).getFacet(DependencyFacet.class);
        Coordinate result = dependency;
        List versions = dependencyFacet.resolveAvailableVersions((DependencyQuery)DependencyQueryBuilder.create((Coordinate)dependency).setFilter((Predicate)new NonSnapshotDependencyFilter()));
        if (versions.size() > 0) {
            result = (Coordinate)versions.get(versions.size() - 1);
        }
        return result;
    }
}

