/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.core.VerifyArgument;
import com.strobel.reflection.GenericParameter;
import com.strobel.reflection.ICapturedType;
import com.strobel.reflection.Type;
import javax.lang.model.type.TypeKind;

final class CapturedType<T>
extends GenericParameter<T>
implements ICapturedType {
    static final String CapturedName = "<captured wildcard>";
    private final Type<?> _wildcard;

    CapturedType(Type<?> declaringType, Type<?> upperBound, Type<?> lowerBound, Type<?> wildcard) {
        super(CapturedName, declaringType, upperBound, lowerBound, -1);
        if (!wildcard.isWildcardType()) {
            throw new IllegalArgumentException("Argument 'wildcard' must be a wildcard type.");
        }
        this._wildcard = (Type)VerifyArgument.notNull(wildcard, (String)"wildcard");
    }

    @Override
    public Type<?> getWildcard() {
        return this._wildcard;
    }

    @Override
    public boolean isGenericParameter() {
        return false;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.WILDCARD;
    }

    @Override
    public boolean isWildcardType() {
        return true;
    }
}

