/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectAssociationProvider;
import org.jboss.forge.addon.projects.ProjectFacet;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ProjectListener;
import org.jboss.forge.addon.projects.ProjectProvider;
import org.jboss.forge.addon.projects.ProvidedProjectFacet;
import org.jboss.forge.addon.projects.spi.ProjectCache;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.events.ResourceEvent;
import org.jboss.forge.addon.resource.monitor.ResourceListener;
import org.jboss.forge.addon.resource.monitor.ResourceMonitor;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.container.simple.AbstractEventListener;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.spi.ListenerRegistration;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.util.Predicate;

public class ProjectFactoryImpl
extends AbstractEventListener
implements ProjectFactory {
    private static final Logger log = Logger.getLogger(ProjectFactoryImpl.class.getName());
    private AddonRegistry addonRegistry;
    private ResourceFactory resourceFactory;
    private FacetFactory facetFactory;
    private Imported<ProjectListener> builtInListeners;
    private Imported<ProjectCache> caches;
    private final List<ListenerRegistration<ResourceListener>> listeners = new ArrayList<ListenerRegistration<ResourceListener>>();
    private final Set<ProjectProvider> providers = new HashSet<ProjectProvider>();
    private long version = -1L;
    private final Predicate<ProjectFacet> notProvidedProjectFacetFilter = new Predicate<ProjectFacet>(){

        public boolean accept(ProjectFacet type) {
            return !(type instanceof ProvidedProjectFacet);
        }
    };
    private final List<ProjectListener> projectListeners = new ArrayList<ProjectListener>();
    private final Predicate<Project> acceptsAllProjects = new Predicate<Project>(){

        public boolean accept(Project type) {
            return true;
        }
    };

    protected void handleThisPreShutdown() {
        this.invalidateCaches();
        for (ListenerRegistration<ResourceListener> registration : this.listeners) {
            registration.removeListener();
        }
    }

    public Project findProject(Resource<?> target) {
        return this.findProject(target, (Predicate<Project>)((Predicate)null));
    }

    public Project findProject(Resource<?> target, ProjectProvider projectProvider) {
        return this.findProject(target, projectProvider, this.acceptsAllProjects);
    }

    public Project findProject(Resource<?> target, Predicate<Project> filter) {
        if (filter == null) {
            filter = this.acceptsAllProjects;
        }
        Project result = null;
        for (Resource<?> dir : this.allDirectoriesOnPath(target)) {
            ProjectProvider projectProvider;
            Iterator<ProjectProvider> iterator = this.getProviders().iterator();
            while (iterator.hasNext() && (result = this.findProjectInDirectory(dir, projectProvider = iterator.next(), filter)) == null) {
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    private Iterable<ProjectProvider> getProviders() {
        AddonRegistry addonRegistry = this.getAddonRegistry();
        if (addonRegistry.getVersion() != this.version) {
            this.version = addonRegistry.getVersion();
            this.providers.clear();
            for (ProjectProvider provider : addonRegistry.getServices(ProjectProvider.class)) {
                this.providers.add(provider);
            }
        }
        return this.providers;
    }

    public Project findProject(Resource<?> target, ProjectProvider projectProvider, Predicate<Project> filter) {
        Assert.notNull(target, (String)"Target cannot be null");
        if (filter == null) {
            filter = this.acceptsAllProjects;
        }
        Project result = null;
        Iterator<Resource<?>> pathIterator = this.allDirectoriesOnPath(target).iterator();
        while (pathIterator.hasNext() && result == null) {
            result = this.findProjectInDirectory(pathIterator.next(), projectProvider, filter);
        }
        return result;
    }

    private List<Resource<?>> allDirectoriesOnPath(Resource<?> startingDir) {
        ArrayList result = new ArrayList();
        while (startingDir != null) {
            result.add(startingDir);
            startingDir = startingDir.getParent();
        }
        return result;
    }

    private Project findProjectInDirectory(Resource<?> target, ProjectProvider projectProvider, Predicate<Project> filter) {
        Project result = null;
        Imported<ProjectCache> caches = this.getCaches();
        if (projectProvider.containsProject(target)) {
            boolean cached = false;
            for (ProjectCache cache : caches) {
                result = cache.get(target);
                if (result != null && !filter.accept((Object)result)) {
                    result = null;
                }
                if (result == null) continue;
                cached = true;
                break;
            }
            if (result == null) {
                result = projectProvider.createProject(target);
            }
            if (result != null && !filter.accept((Object)result)) {
                result = null;
            }
            if (result != null && !cached) {
                this.registerAvailableFacets(result);
                this.cacheProject(result);
            }
        }
        return result;
    }

    public Project createProject(Resource<?> target, ProjectProvider projectProvider) {
        return this.createProject(target, projectProvider, null);
    }

    public Project createProject(Resource<?> target, ProjectProvider projectProvider, Iterable<Class<? extends ProjectFacet>> facetTypes) {
        Resource parent;
        Project result;
        Assert.notNull(target, (String)"Target project directory must not be null.");
        Assert.notNull((Object)projectProvider, (String)"Build system type must not be null.");
        FacetFactory facetFactory = this.getFacetFactory();
        if (facetTypes != null) {
            Assert.isTrue((boolean)this.isBuildable(projectProvider, facetTypes), (String)("The provided build system [" + projectProvider.getType() + "] cannot create a project that requires facets of the following types: " + this.getMissingProvidedProjectFacets(projectProvider, this.getRequiredProvidedProjectFacets(facetTypes))));
        }
        if ((result = projectProvider.createProject(target)) != null && (parent = result.getRoot().getParent()) != null) {
            for (ProjectAssociationProvider provider : this.getAddonRegistry().getServices(ProjectAssociationProvider.class)) {
                if (!provider.canAssociate(result, parent)) continue;
                provider.associate(result, parent);
            }
        }
        if (result != null && facetTypes != null) {
            for (Class<? extends ProjectFacet> facetType : facetTypes) {
                try {
                    ProjectFacet projectFacet;
                    if (ProvidedProjectFacet.class.isAssignableFrom(facetType)) continue;
                    Iterable facets = facetFactory.createFacets((Faceted)result, facetType);
                    Iterator iterator = facets.iterator();
                    while (iterator.hasNext() && !facetFactory.install((Faceted)result, (Facet)(projectFacet = (ProjectFacet)iterator.next()), this.notProvidedProjectFacetFilter)) {
                    }
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Could not install " + Facet.class.getSimpleName() + " of type [" + facetType + "] into Project [" + result + "]", e);
                }
            }
        }
        if (result != null) {
            this.registerAvailableFacets(result);
        }
        if (result != null) {
            this.cacheProject(result);
            this.fireProjectCreated(result);
        }
        return result;
    }

    private Iterable<Class<? extends ProvidedProjectFacet>> getMissingProvidedProjectFacets(ProjectProvider buildSystem, Iterable<Class<? extends ProvidedProjectFacet>> requiredFacets) {
        HashSet<Class<? extends ProvidedProjectFacet>> result = new HashSet<Class<? extends ProvidedProjectFacet>>();
        Iterable providedFacetTypes = buildSystem.getProvidedFacetTypes();
        if (requiredFacets != null && providedFacetTypes != null) {
            for (Class<? extends ProvidedProjectFacet> required : requiredFacets) {
                boolean found = false;
                for (Class provided : providedFacetTypes) {
                    if (!provided.isAssignableFrom(required)) continue;
                    found = true;
                }
                if (found) continue;
                result.add(required);
            }
        }
        return result;
    }

    private boolean isBuildable(ProjectProvider buildSystem, Iterable<Class<? extends ProjectFacet>> facets) {
        boolean result = false;
        Iterable<Class<? extends ProvidedProjectFacet>> requiredFacets = this.getRequiredProvidedProjectFacets(facets);
        result = requiredFacets == null ? true : !this.getMissingProvidedProjectFacets(buildSystem, requiredFacets).iterator().hasNext();
        return result;
    }

    private Iterable<Class<? extends ProvidedProjectFacet>> getRequiredProvidedProjectFacets(Iterable<Class<? extends ProjectFacet>> facets) {
        HashSet<Class<? extends ProvidedProjectFacet>> result = new HashSet<Class<? extends ProvidedProjectFacet>>();
        for (Class<? extends ProjectFacet> facetType : facets) {
            if (!ProvidedProjectFacet.class.isAssignableFrom(facetType)) continue;
            result.add(facetType);
        }
        return result;
    }

    private void registerAvailableFacets(Project result) {
        FacetFactory facetFactory = this.getFacetFactory();
        for (Class type : this.getAddonRegistry().getExportedTypes(ProjectFacet.class)) {
            Iterable facets = facetFactory.createFacets((Faceted)result, type);
            for (ProjectFacet facet : facets) {
                if (facet == null || !facetFactory.register((Faceted)result, (Facet)facet) || !log.isLoggable(Level.FINE)) continue;
                log.fine("Registered Facet [" + facet + "] into Project [" + result + "]");
            }
        }
    }

    private void cacheProject(final Project project) {
        final Imported<ProjectCache> caches = this.getCaches();
        for (ProjectCache cache : caches) {
            cache.store(project);
        }
        DirectoryResource rootDirectory = (DirectoryResource)project.getRoot().reify(DirectoryResource.class);
        if (rootDirectory != null && ((File)rootDirectory.getUnderlyingResourceObject()).exists()) {
            final ResourceMonitor monitor = rootDirectory.monitor();
            ListenerRegistration registration = monitor.addResourceListener(new ResourceListener(){

                public void processEvent(ResourceEvent event) {
                    for (ProjectCache cache : caches) {
                        cache.evict(project);
                    }
                    monitor.cancel();
                }
            });
            this.listeners.add((ListenerRegistration<ResourceListener>)registration);
        }
    }

    private void fireProjectCreated(Project project) {
        for (ProjectListener listener : this.getBuiltInListeners()) {
            listener.projectCreated(project);
        }
        for (ProjectListener listener : this.projectListeners) {
            listener.projectCreated(project);
        }
    }

    public Project createTempProject() throws IllegalStateException {
        return this.createTempProject(Collections.emptySet());
    }

    public Project createTempProject(Iterable<Class<? extends ProjectFacet>> facetTypes) throws IllegalStateException {
        Imported buildSystems = this.getAddonRegistry().getServices(ProjectProvider.class);
        if (buildSystems.isAmbiguous()) {
            throw new IllegalStateException("Cannot create generic temporary project in environment where multiple build systems are available. A single build system must be selected.");
        }
        ProjectProvider buildSystem = (ProjectProvider)buildSystems.get();
        return this.createTempProject(buildSystem, facetTypes);
    }

    public Project createTempProject(ProjectProvider buildSystem) {
        return this.createTempProject(buildSystem, Collections.emptySet());
    }

    public Project createTempProject(ProjectProvider buildSystem, Iterable<Class<? extends ProjectFacet>> facetTypes) {
        File rootDirectory = OperatingSystemUtils.createTempDir();
        DirectoryResource addonDir = (DirectoryResource)this.getResourceFactory().create(DirectoryResource.class, (Object)rootDirectory);
        DirectoryResource projectDir = (DirectoryResource)addonDir.createTempResource();
        projectDir.deleteOnExit();
        Project project = this.createProject((Resource<?>)projectDir, buildSystem, facetTypes);
        return project;
    }

    public ListenerRegistration<ProjectListener> addProjectListener(final ProjectListener listener) {
        Assert.notNull((Object)listener, (String)"Project listener must not be null.");
        this.projectListeners.add(listener);
        return new ListenerRegistration<ProjectListener>(){

            public ProjectListener removeListener() {
                ProjectFactoryImpl.this.projectListeners.remove(listener);
                return listener;
            }
        };
    }

    public boolean containsProject(Resource<?> bound, Resource<?> target) {
        ProjectProvider buildSystem;
        boolean found = false;
        Iterator<ProjectProvider> iterator = this.getProviders().iterator();
        while (iterator.hasNext() && !(found = this.containsProject(bound, target, buildSystem = iterator.next()))) {
        }
        return found;
    }

    public boolean containsProject(Resource<?> bound, Resource<?> target, ProjectProvider buildSystem) {
        Assert.notNull(bound, (String)"Boundary should not be null");
        Assert.isTrue((bound.equals(target) || this.isParent(bound, target) ? 1 : 0) != 0, (String)"Target should be a child of bound");
        boolean found = false;
        for (Resource r = bound; r != null && !found; r = r.getParent()) {
            found = buildSystem.containsProject(r);
            if (target.equals(r)) break;
        }
        return found;
    }

    private boolean isParent(Resource<?> parent, Resource<?> child) {
        for (Resource childDir = child.getParent(); childDir != null; childDir = childDir.getParent()) {
            if (!parent.equals((Object)childDir)) continue;
            return true;
        }
        return false;
    }

    public boolean containsProject(Resource<?> target) {
        ProjectProvider buildSystem;
        boolean found = false;
        Iterator<ProjectProvider> iterator = this.getProviders().iterator();
        while (iterator.hasNext() && !(found = this.containsProject(target, buildSystem = iterator.next()))) {
        }
        return found;
    }

    public boolean containsProject(Resource<?> target, ProjectProvider buildSystem) {
        Assert.notNull(target, (String)"Target resource must not be null.");
        Assert.notNull((Object)buildSystem, (String)"Project build system must not be null.");
        boolean found = false;
        for (Resource r = target; r != null && !found; r = r.getParent()) {
            found = buildSystem.containsProject(r);
        }
        return found;
    }

    public void invalidateCaches() {
        for (ProjectCache cache : this.caches) {
            cache.invalidate();
        }
    }

    private AddonRegistry getAddonRegistry() {
        if (this.addonRegistry == null) {
            this.addonRegistry = SimpleContainer.getFurnace((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getAddonRegistry(new AddonRepository[0]);
        }
        return this.addonRegistry;
    }

    private FacetFactory getFacetFactory() {
        if (this.facetFactory == null) {
            this.facetFactory = (FacetFactory)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), FacetFactory.class).get();
        }
        return this.facetFactory;
    }

    private ResourceFactory getResourceFactory() {
        if (this.resourceFactory == null) {
            this.resourceFactory = (ResourceFactory)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ResourceFactory.class).get();
        }
        return this.resourceFactory;
    }

    private Imported<ProjectCache> getCaches() {
        if (this.caches == null) {
            this.caches = SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ProjectCache.class);
        }
        return this.caches;
    }

    private Imported<ProjectListener> getBuiltInListeners() {
        if (this.builtInListeners == null) {
            this.builtInListeners = SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ProjectListener.class);
        }
        return this.builtInListeners;
    }
}

