/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.ui.dependencies;

import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.projects.ui.dependencies.AddManagedDependenciesCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;

@FacetConstraint(value={DependencyFacet.class})
public class AddManagedDependenciesCommandImpl
extends AbstractProjectCommand
implements AddManagedDependenciesCommand {
    private UIInputMany<Dependency> arguments;

    public void initializeUI(UIBuilder builder) throws Exception {
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.arguments = (UIInputMany)((UIInputMany)((UIInputMany)factory.createInputMany("arguments", 'd', Dependency.class).setLabel("Coordinates")).setRequired(true)).setDescription("The coordinates of the managed arguments to be added [groupId :artifactId {:version :scope :packaging}]");
        builder.add(this.arguments);
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(AddManagedDependenciesCommandImpl.class).description("Add one or more managed dependencies to the current project.").name("Project: Add Managed Dependencies").category(Categories.create((String[])new String[]{"Project", "Manage"}));
    }

    public Result execute(UIExecutionContext context) {
        Project project = this.getSelectedProject(context.getUIContext());
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        if (this.arguments.hasValue()) {
            DependencyInstaller installer = (DependencyInstaller)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), DependencyInstaller.class).get();
            int count = 0;
            for (Dependency dependency : this.arguments.getValue()) {
                Dependency existingDep = deps.getEffectiveManagedDependency((Dependency)DependencyBuilder.create((Dependency)dependency).setVersion(null));
                if (existingDep != null && context.getPrompt().promptBoolean(String.format("Dependency is already managed [%s:%s:%s], reference the managed dependency?", existingDep.getCoordinate().getGroupId(), existingDep.getCoordinate().getArtifactId(), existingDep.getCoordinate().getVersion()))) {
                    return Results.success((String)"Project not updated: No changes required.");
                }
                installer.installManaged(project, dependency);
                ++count;
            }
            return Results.success((String)("Installed [" + count + "] dependenc" + (count == 1 ? "y" : "ies") + "."));
        }
        return Results.fail((String)"No arguments specified.");
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return (ProjectFactory)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ProjectFactory.class).get();
    }
}

