/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.ui.dependencies;

import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.projects.ui.dependencies.RemoveManagedDependenciesCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;

@FacetConstraint(value={DependencyFacet.class})
public class RemoveManagedDependenciesCommandImpl
extends AbstractProjectCommand
implements RemoveManagedDependenciesCommand {
    private UISelectMany<Dependency> arguments;
    private UIInput<Boolean> removeUnmanaged;

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject(builder.getUIContext());
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.arguments = (UISelectMany)((UISelectMany)((UISelectMany)factory.createSelectMany("arguments", 'd', Dependency.class).setLabel("Coordinates")).setRequired(true)).setDescription("The coordinates of the managed arguments to be removed [groupId :artifactId {:version :scope :packaging}]");
        this.removeUnmanaged = (UIInput)((UIInput)((UIInput)factory.createInput("removeUnmanaged", 'r', Boolean.class).setLabel("Remove managed arguments")).setDefaultValue((Object)false)).setDescription("Also remove any related arguments from the current project if they are now un-managed, if possible.");
        this.arguments.setValueChoices((Iterable)((DependencyFacet)project.getFacet(DependencyFacet.class)).getManagedDependencies());
        builder.add(this.arguments).add(this.removeUnmanaged);
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(RemoveManagedDependenciesCommandImpl.class).description("Remove one or more managed arguments from the current project.").name("Project: Remove Managed Dependencies").category(Categories.create((String[])new String[]{"Project", "Manage"}));
    }

    public Result execute(UIExecutionContext context) {
        Project project = this.getSelectedProject(context.getUIContext());
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        if (this.arguments.hasValue()) {
            int count = 0;
            for (Dependency gav : this.arguments.getValue()) {
                deps.removeManagedDependency(gav);
                if (((Boolean)this.removeUnmanaged.getValue()).booleanValue() && !deps.hasEffectiveManagedDependency(gav)) {
                    deps.removeDependency(gav);
                }
                ++count;
            }
            return Results.success((String)("Removed [" + count + "] dependenc" + (count == 1 ? "y" : "ies") + "."));
        }
        return Results.fail((String)"No arguments specified.");
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return (ProjectFactory)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ProjectFactory.class).get();
    }
}

