/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.schema.EdgeLabelMaker;
import com.thinkaurelius.titan.graphdb.database.IndexSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeHandling;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.StandardRelationTypeMaker;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionMap;
import com.tinkerpop.blueprints.Direction;

public class StandardEdgeLabelMaker
extends StandardRelationTypeMaker
implements EdgeLabelMaker {
    private Direction unidirectionality = Direction.BOTH;

    public StandardEdgeLabelMaker(StandardTitanTx tx, IndexSerializer indexSerializer, AttributeHandling attributeHandler) {
        super(tx, indexSerializer, attributeHandler);
    }

    @Override
    public StandardEdgeLabelMaker directed() {
        this.unidirectionality = Direction.BOTH;
        return this;
    }

    @Override
    public StandardEdgeLabelMaker unidirected() {
        return this.unidirected(Direction.OUT);
    }

    public StandardEdgeLabelMaker unidirected(Direction dir) {
        Preconditions.checkNotNull((Object)dir);
        this.unidirectionality = dir;
        return this;
    }

    @Override
    public StandardEdgeLabelMaker multiplicity(Multiplicity multiplicity) {
        super.multiplicity(multiplicity);
        return this;
    }

    @Override
    public StandardEdgeLabelMaker signature(RelationType ... types) {
        super.signature(types);
        return this;
    }

    @Override
    public StandardEdgeLabelMaker sortKey(RelationType ... types) {
        super.sortKey(types);
        return this;
    }

    @Override
    public StandardEdgeLabelMaker sortOrder(Order order) {
        super.sortOrder(order);
        return this;
    }

    @Override
    public StandardEdgeLabelMaker hidden() {
        super.hidden();
        return this;
    }

    @Override
    public EdgeLabel make() {
        TypeDefinitionMap definition = this.makeDefinition();
        Preconditions.checkArgument((this.unidirectionality == Direction.BOTH || !this.getMultiplicity().isUnique(this.unidirectionality.opposite()) ? 1 : 0) != 0, (Object)"Unidirectional labels cannot have restricted multiplicity at the other end");
        Preconditions.checkArgument((this.unidirectionality == Direction.BOTH || !this.hasSortKey() || !this.getMultiplicity().isUnique(this.unidirectionality) ? 1 : 0) != 0, (Object)"Unidirectional labels with restricted multiplicity cannot have a sort key");
        Preconditions.checkArgument((this.unidirectionality != Direction.IN || definition.getValue(TypeDefinitionCategory.HIDDEN, Boolean.class) != false ? 1 : 0) != 0);
        definition.setValue(TypeDefinitionCategory.UNIDIRECTIONAL, this.unidirectionality);
        return this.tx.makeEdgeLabel(this.getName(), definition);
    }
}

