/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.tattletale;

import java.io.File;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.jboss.tattletale.Main;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class TattletaleRuleProvider
extends AbstractRuleProvider {
    public static final String REPORT_TEMPLATE = "/reports/templates/embedded.ftl";
    private static final String TATTLETALE_REPORT_SUBDIR = "tattletale";
    public static final String REPORT_DESCRIPTION = "This report contains the results of running Tattletale on the input application.";

    public TattletaleRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(TattletaleRuleProvider.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        return ConfigurationBuilder.begin().addRule().perform((Operation)new TattletaleOperation());
    }

    private class TattletaleOperation
    extends GraphOperation {
        private static final String TTALE_CONFIG_FILE_NAME = "tattletale-config.properties";

        private TattletaleOperation() {
        }

        public void perform(GraphRewrite event, EvaluationContext context) {
            Boolean generateReport = (Boolean)event.getGraphContext().getOptionMap().get("enableTattletale");
            if (generateReport == null || !generateReport.booleanValue()) {
                return;
            }
            WindupConfigurationModel configuration = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
            for (FileModel input : configuration.getInputPaths()) {
                String inputPath = input.getFilePath();
                String reportDirectory = new ReportService(event.getGraphContext()).getReportDirectory();
                String tattletaleRelativePath = TattletaleRuleProvider.TATTLETALE_REPORT_SUBDIR + File.separator + input.getFileName();
                Path tattletaleReportPath = Paths.get(reportDirectory, tattletaleRelativePath);
                int i = 1;
                while (Files.exists(tattletaleReportPath, new LinkOption[0])) {
                    tattletaleRelativePath = TattletaleRuleProvider.TATTLETALE_REPORT_SUBDIR + File.separator + input.getFileName() + "." + i;
                    tattletaleReportPath = Paths.get(reportDirectory, tattletaleRelativePath);
                    ++i;
                }
                String tattletaleDir = tattletaleReportPath.toString();
                Main main = new Main();
                main.setSource(inputPath);
                main.setDestination(tattletaleDir);
                try {
                    new File(tattletaleDir).mkdirs();
                    File configPath = new File(tattletaleDir, TTALE_CONFIG_FILE_NAME);
                    PrintStream str = new PrintStream(configPath);
                    str.append("enableDot=false\n");
                    str.append("graphvizDot=dot\n");
                    str.close();
                    main.setConfiguration(configPath.getAbsolutePath());
                    main.execute();
                    this.createReportModel(event.getGraphContext(), input, tattletaleRelativePath);
                }
                catch (Exception e) {
                    throw new WindupException("Failed to run Tattletale due to: " + e.getMessage());
                }
            }
        }

        private void createReportModel(GraphContext context, FileModel input, String reportRelativePath) {
            ProjectModel inputProjectModel = input.getProjectModel();
            ApplicationReportModel applicationReportModel = new ApplicationReportService(context).create();
            applicationReportModel.setReportName("Tattletale");
            applicationReportModel.setDescription(TattletaleRuleProvider.REPORT_DESCRIPTION);
            applicationReportModel.setReportIconClass("glyphicon tattletale-nav-logo");
            applicationReportModel.setReportPriority(500);
            applicationReportModel.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
            applicationReportModel.setProjectModel(inputProjectModel);
            applicationReportModel.setTemplatePath(TattletaleRuleProvider.REPORT_TEMPLATE);
            applicationReportModel.setTemplateType(TemplateType.FREEMARKER);
            HashMap<String, String> reportProperties = new HashMap<String, String>();
            reportProperties.put("embeddedTitle", "Tattletale Report");
            reportProperties.put("embeddedUrl", reportRelativePath + "/index.html");
            applicationReportModel.setReportProperties(reportProperties);
            ReportService reportService = new ReportService(context);
            reportService.setUniqueFilename((ReportModel)applicationReportModel, "tattletale_" + inputProjectModel.getName(), "html");
        }
    }
}

