/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.git.gitignore;

public class GitIgnoreEntry {
    private String content;
    private boolean pattern;
    private boolean comment;
    private boolean negate;

    public GitIgnoreEntry(String line) {
        if (line.startsWith("!")) {
            this.content = line.substring(1);
            this.pattern = true;
            this.negate = true;
        } else if (line.startsWith("#")) {
            this.content = line.substring(1).trim();
            this.comment = true;
        } else if (line.length() > 0) {
            this.content = line;
            this.pattern = true;
        }
    }

    public GitIgnoreEntry(String content, boolean pattern, boolean negate) {
        this.content = content;
        this.pattern = pattern;
        this.negate = negate;
    }

    public String getContent() {
        return this.content;
    }

    public boolean isPattern() {
        return this.pattern;
    }

    public boolean isComment() {
        return this.comment;
    }

    public boolean isNegate() {
        return this.negate;
    }

    public boolean isBlank() {
        return this.content != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comment ? 1231 : 1237);
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        result = 31 * result + (this.negate ? 1231 : 1237);
        result = 31 * result + (this.pattern ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GitIgnoreEntry other = (GitIgnoreEntry)obj;
        if (this.comment != other.comment) {
            return false;
        }
        if (this.content == null ? other.content != null : !this.content.equals(other.content)) {
            return false;
        }
        if (this.negate != other.negate) {
            return false;
        }
        return this.pattern == other.pattern;
    }

    public String toString() {
        if (this.content == null) {
            return "";
        }
        if (this.comment) {
            return "# " + this.content;
        }
        if (this.negate) {
            return "!" + this.content;
        }
        return this.content;
    }
}

