/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules.rendering;

import java.util.HashMap;
import javax.inject.Inject;
import org.jboss.forge.furnace.Furnace;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.PostReportGenerationPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.model.WindupVertexListModel;
import org.jboss.windup.reporting.rules.AttachApplicationReportsToIndexRuleProvider;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CreateApplicationListReportRuleProvider
extends AbstractRuleProvider {
    public static final String APPLICATION_LIST_REPORT = "Application List";
    private static final String OUTPUT_FILENAME = "../index.html";
    private static final String TEMPLATE_PATH = "/reports/templates/application_list.ftl";
    @Inject
    private Furnace furnace;

    public CreateApplicationListReportRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(CreateApplicationListReportRuleProvider.class).setPhase(PostReportGenerationPhase.class).addExecuteBefore(AttachApplicationReportsToIndexRuleProvider.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        return ConfigurationBuilder.begin().addRule().perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                CreateApplicationListReportRuleProvider.this.createIndexReport(event.getGraphContext());
            }
        });
    }

    private void createIndexReport(GraphContext context) {
        ApplicationReportService applicationReportService = new ApplicationReportService(context);
        ApplicationReportModel report = applicationReportService.create();
        report.setReportPriority(1);
        report.setReportIconClass("glyphicon glyphicon-home");
        report.setReportName(APPLICATION_LIST_REPORT);
        report.setTemplatePath(TEMPLATE_PATH);
        report.setTemplateType(TemplateType.FREEMARKER);
        report.setDisplayInApplicationReportIndex(Boolean.valueOf(false));
        report.setReportFilename(OUTPUT_FILENAME);
        GraphService listService = new GraphService(context, WindupVertexListModel.class);
        WindupVertexListModel applications = (WindupVertexListModel)listService.create();
        for (ApplicationReportModel applicationReportModel : applicationReportService.findAll()) {
            if (!applicationReportModel.isMainApplicationReport().booleanValue()) continue;
            applications.addItem((WindupVertexFrame)applicationReportModel);
        }
        HashMap<String, WindupVertexListModel> relatedData = new HashMap<String, WindupVertexListModel>();
        relatedData.put("applications", applications);
        report.setRelatedResource(relatedData);
    }
}

