/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap.help;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.SAXReader;
import org.jboss.forge.furnace.Furnace;
import org.jboss.windup.bootstrap.help.OptionDescription;
import org.jboss.windup.config.ConfigurationOption;
import org.jboss.windup.exec.configuration.WindupConfiguration;
import org.jboss.windup.util.PathUtil;

public class Help {
    private static final String HELP = "help";
    private static final String OPTION = "option";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private List<OptionDescription> options = new ArrayList<OptionDescription>();

    public List<OptionDescription> getOptions() {
        return this.options;
    }

    private void addOption(OptionDescription optionDescription) {
        this.options.add(optionDescription);
    }

    private static File getDefaultFile() throws IOException {
        Path helpDirectory = PathUtil.getWindupHome().resolve("cache").resolve(HELP);
        if (!Files.exists(helpDirectory, new LinkOption[0])) {
            Files.createDirectories(helpDirectory, new FileAttribute[0]);
        }
        Path helpPath = helpDirectory.resolve("help.xml");
        return helpPath.toFile();
    }

    public static Help load() {
        Help result = new Help();
        try {
            Document doc = new SAXReader().read(Help.getDefaultFile());
            Iterator optionElementIterator = doc.getRootElement().elementIterator(OPTION);
            while (optionElementIterator.hasNext()) {
                Element optionElement = (Element)optionElementIterator.next();
                String name = optionElement.attributeValue(NAME);
                String description = optionElement.element(DESCRIPTION).getText();
                OptionDescription option = new OptionDescription(name, description);
                result.addOption(option);
            }
        }
        catch (IOException | DocumentException e) {
            System.err.println("WARNING: Failed to load detailed help information!");
        }
        return result;
    }

    public static void save(Furnace furnace) throws IOException {
        DOMDocument doc = new DOMDocument(new DOMElement(HELP));
        Iterable windupOptions = WindupConfiguration.getWindupConfigurationOptions((Furnace)furnace);
        for (ConfigurationOption option : windupOptions) {
            DOMElement optionElement = new DOMElement(OPTION);
            optionElement.addAttribute(NAME, option.getName());
            DOMElement descriptionElement = new DOMElement(DESCRIPTION);
            descriptionElement.setText(option.getDescription());
            optionElement.add((Element)descriptionElement);
            doc.getRootElement().add((Element)optionElement);
        }
        try (FileWriter writer = new FileWriter(Help.getDefaultFile());){
            doc.write((Writer)writer);
        }
    }
}

