/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.frames.structures.FramedVertexIterable;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateModelException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.util.ExecutionStatistics;

public class GetTagsFromFileClassificationsAndHints
implements WindupFreeMarkerMethod {
    private static final String NAME = "getTagsFromFileClassificationsAndHints";
    private GraphContext context;

    @Override
    public void setContext(GraphRewrite event) {
        this.context = event.getGraphContext();
    }

    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (" + FileModel.class.getSimpleName() + ")");
        }
        StringModel stringModelArg = (StringModel)arguments.get(0);
        FileModel fileModel = (FileModel)stringModelArg.getWrappedObject();
        Set<String> tags = this.findTagsFromFileClassificationsAndHints(fileModel);
        ExecutionStatistics.get().end(NAME);
        return tags;
    }

    @Override
    public String getMethodName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return "Takes a " + FileModel.class.getSimpleName() + " as a parameter and returns an Set<String> containing the tags" + " from the classifications associated with the provided this file.";
    }

    private Set<String> findTagsFromFileClassificationsAndHints(FileModel fileModel) {
        HashSet<String> tags = new HashSet<String>();
        GremlinPipeline pipeline = new GremlinPipeline((Object)fileModel.asVertex());
        pipeline.in(new String[]{"ClassificationModel:classificationModelToFileModel"}).has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"ClassificationModel");
        FramedVertexIterable iterable = new FramedVertexIterable(this.context.getFramed(), (Iterable)pipeline, ClassificationModel.class);
        for (ClassificationModel classification : iterable) {
            tags.addAll(classification.getTags());
        }
        pipeline = new GremlinPipeline((Object)fileModel.asVertex());
        pipeline.in(new String[]{"file"}).has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"fileLocationModel");
        pipeline.in(new String[]{"Hint:fileLocationReference"}).has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"Hint");
        iterable = new FramedVertexIterable(this.context.getFramed(), (Iterable)pipeline, InlineHintModel.class);
        for (InlineHintModel hint : iterable) {
            tags.addAll(hint.getTags());
        }
        return tags;
    }
}

