/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules;

import org.jboss.forge.furnace.util.Iterators;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.PreReportGenerationPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderFind;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.ApplicationReportIndexModel;
import org.jboss.windup.reporting.service.ApplicationReportIndexService;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CreateApplicationReportIndexRuleProvider
extends AbstractRuleProvider {
    public CreateApplicationReportIndexRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(CreateApplicationReportIndexRuleProvider.class).setPhase(PreReportGenerationPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        QueryBuilderFind applicationsFound = Query.fromType(WindupConfigurationModel.class);
        AbstractIterationOperation<WindupConfigurationModel> addApplicationReportIndex = new AbstractIterationOperation<WindupConfigurationModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, WindupConfigurationModel payload) {
                for (FileModel inputPath : payload.getInputPaths()) {
                    ProjectModel projectModel = inputPath.getProjectModel();
                    if (projectModel == null) {
                        throw new WindupException("Error, no project found in: " + inputPath.getFilePath());
                    }
                    CreateApplicationReportIndexRuleProvider.this.createApplicationReportIndex(event.getGraphContext(), projectModel);
                }
            }

            public String toString() {
                return "AddApplicationReportIndex";
            }
        };
        return ConfigurationBuilder.begin().addRule().when((Condition)applicationsFound).perform((Operation)addApplicationReportIndex);
    }

    private ApplicationReportIndexModel createApplicationReportIndex(GraphContext context, ProjectModel applicationProjectModel) {
        ApplicationReportIndexService applicationReportIndexService = new ApplicationReportIndexService(context);
        ApplicationReportIndexModel index = (ApplicationReportIndexModel)applicationReportIndexService.create();
        this.addAllProjectModels(index, applicationProjectModel);
        return index;
    }

    private void addAllProjectModels(ApplicationReportIndexModel navIdx, ProjectModel projectModel) {
        navIdx.addProjectModel(projectModel);
        for (ProjectModel childProject : projectModel.getChildProjects()) {
            if (Iterators.asSet(navIdx.getProjectModels()).contains(childProject)) continue;
            this.addAllProjectModels(navIdx, childProject);
        }
    }
}

