/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.fulgora;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.olap.Combiner;
import com.thinkaurelius.titan.core.olap.Gather;
import com.thinkaurelius.titan.core.olap.OLAPJob;
import com.thinkaurelius.titan.core.olap.OLAPJobBuilder;
import com.thinkaurelius.titan.core.olap.OLAPQueryBuilder;
import com.thinkaurelius.titan.core.olap.OLAPResult;
import com.thinkaurelius.titan.core.olap.StateInitializer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.fulgora.FulgoraEdgeQuery;
import com.thinkaurelius.titan.graphdb.fulgora.FulgoraExecutor;
import com.thinkaurelius.titan.graphdb.fulgora.FulgoraPropertyQuery;
import com.thinkaurelius.titan.graphdb.fulgora.FulgoraRelationQuery;
import com.thinkaurelius.titan.graphdb.fulgora.FulgoraResult;
import com.thinkaurelius.titan.graphdb.internal.RelationCategory;
import com.thinkaurelius.titan.graphdb.query.BackendQueryHolder;
import com.thinkaurelius.titan.graphdb.query.vertex.BaseVertexCentricQuery;
import com.thinkaurelius.titan.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.transaction.StandardTransactionBuilder;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;

public class FulgoraBuilder<S>
implements OLAPJobBuilder<S> {
    public static final String STATE_KEY = "state";
    public static final int DEFAULT_HARD_QUERY_LIMIT = 100000;
    private static final int NUM_VERTEX_DEFAULT = 10000;
    private static final StateInitializer NULL_STATE = new StateInitializer(){

        public Object initialState() {
            return null;
        }
    };
    private final StandardTitanGraph graph;
    private OLAPJob olapJob;
    private String stateKey;
    private StateInitializer<S> initializer;
    private FulgoraResult<S> initialState;
    private Map<String, Object> txOptions;
    private Map<String, FulgoraRelationQuery> queries;
    private int numProcessingThreads;
    private int numVertices;
    private int hardQueryLimit;

    public FulgoraBuilder(StandardTitanGraph graph) {
        Preconditions.checkArgument((graph != null ? 1 : 0) != 0);
        this.graph = graph;
        this.stateKey = STATE_KEY;
        this.initializer = NULL_STATE;
        this.initialState = null;
        this.txOptions = new HashMap<String, Object>();
        this.queries = new HashMap<String, FulgoraRelationQuery>();
        this.numProcessingThreads = 2;
        this.numVertices = -1;
        this.hardQueryLimit = 100000;
    }

    @Override
    public FulgoraBuilder<S> setJob(OLAPJob job) {
        Preconditions.checkArgument((job != null ? 1 : 0) != 0);
        this.olapJob = job;
        return this;
    }

    @Override
    public FulgoraBuilder<S> setStateKey(String stateKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)stateKey));
        this.stateKey = stateKey;
        return this;
    }

    @Override
    public FulgoraBuilder<S> setInitializer(StateInitializer<S> initial) {
        Preconditions.checkNotNull(initial);
        this.initializer = initial;
        return this;
    }

    @Override
    public FulgoraBuilder<S> setInitialState(Map<Long, S> values) {
        Preconditions.checkArgument((values != null ? 1 : 0) != 0);
        this.initialState = new FulgoraResult<S>(values, this.graph.getIDManager());
        return this;
    }

    @Override
    public OLAPJobBuilder<S> setInitialState(OLAPResult<S> values) {
        Preconditions.checkArgument((values != null && values instanceof FulgoraResult ? 1 : 0) != 0, (Object)("Invalid result set provided: " + values));
        this.initialState = (FulgoraResult)values;
        return this;
    }

    @Override
    public FulgoraBuilder<S> setNumVertices(long numVertices) {
        Preconditions.checkArgument((numVertices > 0L && numVertices < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Invalid value for number of vertices: %s", (Object[])new Object[]{numVertices});
        this.numVertices = (int)numVertices;
        return this;
    }

    @Override
    public FulgoraBuilder<S> setNumProcessingThreads(int numThreads) {
        Preconditions.checkArgument((numThreads > 0 ? 1 : 0) != 0, (String)"Need to specify a positive number of processing threads: %s", (Object[])new Object[]{numThreads});
        this.numProcessingThreads = numThreads;
        return this;
    }

    public FulgoraBuilder<S> setCustomTxOptions(String key, Object value) {
        Preconditions.checkArgument((StringUtils.isNotBlank((String)key) && value != null ? 1 : 0) != 0);
        this.txOptions.put(key, value);
        return this;
    }

    @Override
    public OLAPQueryBuilder addQuery() {
        return new QueryBuilder((StandardTitanTx)this.graph.buildTransaction().readOnly().setVertexCacheSize(100).start());
    }

    @Override
    public Future<OLAPResult<S>> execute() {
        Preconditions.checkArgument((!this.queries.isEmpty() ? 1 : 0) != 0, (Object)"Need to register at least one query");
        StandardTransactionBuilder txBuilder = this.graph.buildTransaction().readOnly().setVertexCacheSize(100);
        for (Map.Entry<String, Object> txOption : this.txOptions.entrySet()) {
            txBuilder.setCustomOption(txOption.getKey(), txOption.getValue());
        }
        StandardTitanTx tx = (StandardTitanTx)txBuilder.start();
        FulgoraResult state = this.initialState != null ? this.initialState : new FulgoraResult(this.numVertices >= 0 ? this.numVertices : 10000, this.graph.getIDManager());
        FulgoraExecutor<S> executor = new FulgoraExecutor<S>(this.queries, tx, this.graph.getIDManager(), this.numProcessingThreads, this.stateKey, this.olapJob, this.initializer, state);
        new Thread(executor).start();
        return executor;
    }

    private class QueryBuilder<M>
    extends BasicVertexCentricQueryBuilder<QueryBuilder<M>>
    implements OLAPQueryBuilder<S, M, QueryBuilder<M>> {
        private final StandardTitanTx tx;
        private String name;

        public QueryBuilder(StandardTitanTx tx) {
            super(tx);
            this.name = null;
            this.tx = tx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<SliceQuery> relations(RelationCategory returnType) {
            if (this.name == null) {
                if (this.hasSingleType()) {
                    this.name = this.getSingleType().getName();
                } else {
                    throw new IllegalStateException("Need to specify an explicit name for this query");
                }
            }
            try {
                BaseVertexCentricQuery vq = super.constructQuery(returnType);
                ArrayList<SliceQuery> queries = new ArrayList<SliceQuery>(vq.numSubQueries());
                for (int i = 0; i < vq.numSubQueries(); ++i) {
                    BackendQueryHolder<SliceQuery> bq = vq.getSubQuery(i);
                    SliceQuery sq = bq.getBackendQuery();
                    queries.add(sq.updateLimit(bq.isFitted() ? vq.getLimit() : FulgoraBuilder.this.hardQueryLimit));
                }
                ArrayList<SliceQuery> arrayList = queries;
                return arrayList;
            }
            finally {
                this.tx.rollback();
            }
        }

        @Override
        protected QueryBuilder getThis() {
            return this;
        }

        @Override
        public QueryBuilder setName(String name) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (String)"Invalid name provided: %s", (Object[])new Object[]{name});
            this.name = name;
            return this.getThis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <M> FulgoraBuilder<S> edges(Gather<S, M> gather, Combiner<M> combiner) {
            List<SliceQuery> qs = this.relations(RelationCategory.EDGE);
            Map map = FulgoraBuilder.this.queries;
            synchronized (map) {
                Preconditions.checkArgument((!FulgoraBuilder.this.queries.containsKey(this.name) ? 1 : 0) != 0, (String)"Name already in use: %s", (Object[])new Object[]{this.name});
                FulgoraBuilder.this.queries.put(this.name, new FulgoraEdgeQuery(qs, gather, combiner));
            }
            return FulgoraBuilder.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <M> FulgoraBuilder<S> properties(Function<TitanProperty, M> gather, Combiner<M> combiner) {
            List<SliceQuery> qs = this.relations(RelationCategory.PROPERTY);
            Map map = FulgoraBuilder.this.queries;
            synchronized (map) {
                Preconditions.checkArgument((!FulgoraBuilder.this.queries.containsKey(this.name) ? 1 : 0) != 0, (String)"Name already in use: %s", (Object[])new Object[]{this.name});
                FulgoraBuilder.this.queries.put(this.name, new FulgoraPropertyQuery<M>(qs, gather, combiner));
            }
            return FulgoraBuilder.this;
        }

        @Override
        public FulgoraBuilder<S> edges(Combiner<S> combiner) {
            return this.edges(FulgoraEdgeQuery.getDefaultGather(), combiner);
        }

        @Override
        public FulgoraBuilder<S> properties(Combiner<Object> combiner) {
            return this.properties((Function)FulgoraPropertyQuery.SINGLE_VALUE_GATHER, (Combiner)combiner);
        }

        @Override
        public FulgoraBuilder<S> properties() {
            if (this.hasSingleType()) {
                RelationType type = this.getSingleType();
                Preconditions.checkArgument((boolean)(type instanceof PropertyKey));
                if (((PropertyKey)type).getCardinality() == Cardinality.SINGLE) {
                    return this.properties((Function)FulgoraPropertyQuery.SINGLE_VALUE_GATHER, (Combiner)FulgoraPropertyQuery.SINGLE_COMBINER);
                }
            }
            return this.properties((Function)FulgoraPropertyQuery.VALUE_LIST_GATHER, (Combiner)FulgoraPropertyQuery.VALUE_LIST_COMBINER);
        }

        @Override
        public QueryBuilder has(PropertyKey key, Object value) {
            super.has(key, value);
            return this;
        }

        @Override
        public QueryBuilder has(EdgeLabel label, TitanVertex vertex) {
            super.has(label, vertex);
            return this;
        }

        @Override
        public QueryBuilder has(String type, Object value) {
            super.has(type, value);
            return this;
        }

        @Override
        public QueryBuilder hasNot(String key, Object value) {
            super.hasNot(key, value);
            return this;
        }

        @Override
        public QueryBuilder has(String key, Predicate predicate, Object value) {
            super.has(key, predicate, value);
            return this;
        }

        @Override
        public QueryBuilder has(PropertyKey key, Predicate predicate, Object value) {
            super.has(key, predicate, value);
            return this;
        }

        @Override
        public QueryBuilder has(String key) {
            super.has(key);
            return this;
        }

        @Override
        public QueryBuilder hasNot(String key) {
            super.hasNot(key);
            return this;
        }

        @Override
        public <T extends Comparable<?>> QueryBuilder interval(PropertyKey key, T start, T end) {
            super.interval(key, start, end);
            return this;
        }

        @Override
        public <T extends Comparable<?>> QueryBuilder interval(String key, T start, T end) {
            super.interval(key, start, end);
            return this;
        }

        @Override
        public QueryBuilder types(RelationType ... types) {
            super.types(types);
            return this;
        }

        @Override
        public QueryBuilder labels(String ... labels) {
            super.labels(labels);
            return this;
        }

        @Override
        public QueryBuilder keys(String ... keys) {
            super.keys(keys);
            return this;
        }

        @Override
        public QueryBuilder type(RelationType type) {
            super.type(type);
            return this;
        }

        @Override
        public QueryBuilder direction(Direction d) {
            super.direction(d);
            return this;
        }

        @Override
        public QueryBuilder limit(int limit) {
            super.limit(limit);
            return this;
        }
    }
}

