/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.git.gitignore;

import java.io.File;
import org.jboss.forge.addon.configuration.Configuration;
import org.jboss.forge.addon.configuration.ConfigurationFactory;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;

public class GitIgnoreConfig {
    private ConfigurationFactory configFactory;

    public String defaultRemoteRepository() {
        return "https://github.com/github/gitignore.git";
    }

    public String remoteRepository() {
        Configuration user = this.userConfig();
        if (user.containsKey("gitignore.plugin.repo")) {
            return user.getString("gitignore.plugin.repo");
        }
        return this.defaultRemoteRepository();
    }

    public void setRemoteRepository(String repoUrl) {
        this.userConfig().setProperty("gitignore.plugin.repo", (Object)repoUrl);
    }

    public File defaultLocalRepository() {
        return new File(System.getProperty("user.home") + File.separator + ".gitignore_boilerplate");
    }

    public File localRepository() {
        Configuration user = this.userConfig();
        if (user.containsKey("gitignore.plugin.clone")) {
            return new File(user.getString("gitignore.plugin.clone"));
        }
        return this.defaultLocalRepository();
    }

    public void setLocalRepository(String location) {
        this.userConfig().setProperty("gitignore.plugin.clone", (Object)location);
    }

    private Configuration userConfig() {
        return this.getConfigFactory().getUserConfiguration();
    }

    private ConfigurationFactory getConfigFactory() {
        if (this.configFactory == null) {
            AddonRegistry addonRegistry = SimpleContainer.getFurnace((ClassLoader)this.getClass().getClassLoader()).getAddonRegistry(new AddonRepository[0]);
            this.configFactory = (ConfigurationFactory)addonRegistry.getServices(ConfigurationFactory.class).get();
        }
        return this.configFactory;
    }
}

