/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.git.ui;

import java.io.File;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.jboss.forge.addon.git.ui.AbstractGitCommand;
import org.jboss.forge.addon.git.ui.GitCloneCommand;
import org.jboss.forge.addon.git.ui.ProgressMonitorAdapter;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

public class GitCloneCommandImpl
extends AbstractGitCommand
implements GitCloneCommand {
    private UIInput<String> uri;
    private UIInput<DirectoryResource> targetDirectory;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("GIT: Clone").description("Clone a GIT repository");
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        this.uri = (UIInput)((UIInput)((UIInput)this.getInputComponentFactory().createInput("uri", String.class).setLabel("URI")).setDescription("Git repository URI")).setRequired(true);
        this.targetDirectory = (UIInput)((UIInput)this.getInputComponentFactory().createInput("targetDirectory", DirectoryResource.class).setLabel("Target directory")).setRequired(true);
        builder.add(this.uri).add(this.targetDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(UIExecutionContext context) throws Exception {
        DirectoryResource cloneFolder = (DirectoryResource)this.targetDirectory.getValue();
        if (!cloneFolder.exists()) {
            cloneFolder.mkdirs();
        }
        Git clone = null;
        try {
            CloneCommand cloneCommand = Git.cloneRepository().setURI((String)this.uri.getValue()).setDirectory((File)cloneFolder.getUnderlyingResourceObject());
            cloneCommand.setProgressMonitor((ProgressMonitor)new ProgressMonitorAdapter(context.getProgressMonitor()));
            clone = cloneCommand.call();
        }
        catch (Throwable throwable) {
            this.getGitUtils().close(clone);
            throw throwable;
        }
        this.getGitUtils().close(clone);
        context.getUIContext().setSelection((Object)cloneFolder);
        return Results.success();
    }

    public void validate(UIValidationContext validator) {
        DirectoryResource folder = (DirectoryResource)this.targetDirectory.getValue();
        if (folder == null || folder.exists() && (!folder.isDirectory() || !folder.listResources().isEmpty())) {
            validator.addValidationError(this.targetDirectory, "The specified target directory should not exist or should be empty directory");
        }
    }

    @Override
    protected boolean isProjectRequired() {
        return false;
    }
}

