/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.git.ui;

import org.jboss.forge.addon.git.gitignore.resources.GitIgnoreResource;
import org.jboss.forge.addon.git.ui.AbstractGitCommand;
import org.jboss.forge.addon.git.ui.GitIgnoreRemovePatternCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

public class GitIgnoreRemovePatternCommandImpl
extends AbstractGitCommand
implements GitIgnoreRemovePatternCommand {
    private UIInput<String> pattern;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("GIT: Remove pattern").description("Remove pattern from .gitignore");
    }

    public boolean isEnabled(UIContext context) {
        return super.isEnabled(context) && this.isGitIgnoreSelected(context);
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        this.pattern = (UIInput)((UIInput)this.getInputComponentFactory().createInput("pattern", String.class).setLabel("Pattern")).setRequired(true);
        this.pattern.setCompleter((UICompleter)new GitIgnorePatternCompleter(this.gitIgnoreResource(builder.getUIContext())));
        builder.add(this.pattern);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        GitIgnoreResource gitIgnore = this.gitIgnoreResource(context.getUIContext());
        gitIgnore.removePattern((String)this.pattern.getValue());
        return Results.success((String)"Pattern removed from the .gitignore in the current directory");
    }

    private static class GitIgnorePatternCompleter
    implements UICompleter<String> {
        private final GitIgnoreResource resource;

        public GitIgnorePatternCompleter(GitIgnoreResource resource) {
            this.resource = resource;
        }

        public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
            return this.resource.getPatterns();
        }
    }
}

